// ***************************************************************************************************************************
// * Licensed to the Apache Software Foundation (ASF) under one or more contributor license agreements.  See the NOTICE file *
// * distributed with this work for additional information regarding copyright ownership.  The ASF licenses this file        *
// * to you under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance            *
// * with the License.  You may obtain a copy of the License at                                                              *
// *                                                                                                                         *
// *  http://www.apache.org/licenses/LICENSE-2.0                                                                             *
// *                                                                                                                         *
// * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an  *
// * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the License for the        *
// * specific language governing permissions and limitations under the License.                                              *
// ***************************************************************************************************************************
package org.apache.juneau.jsonschema.annotation;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.*;

import java.lang.annotation.*;

/**
 * @deprecated Use {@link Schema}
 */
@Documented
@Target({TYPE,METHOD,FIELD})
@Retention(RUNTIME)
@Inherited
@Deprecated
public @interface JsonSchema {

	/**
	 * Defines the type for the class or property.
	 */
	String type() default "";

	/**
	 * Defines the format for the class or property.
	 */
	String format() default "";

	/**
	 * Defines the description for the class or property.
	 */
	String description() default "";

	/**
	 * Defines the example for the class or property.
	 *
	 * <p>
	 * The format of the value is Lax-JSON.
	 */
	String example() default "";
}
