/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.doc.internal;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.doc.internal.Console;
import org.apache.juneau.doc.internal.IOUtils;

public class DocLinkTester {
    private static Map<String, Set<String>> ANCHORS = new LinkedHashMap<String, Set<String>>();
    private static Pattern p = Pattern.compile("(href|src)\\=['\\\"]([^'\\\"]+)['\\\"]");
    private static Pattern p2 = Pattern.compile("(name|id)\\=['\\\"]([^'\\\"]+)['\\\"]");
    private static int errors;
    private static int files;
    private static int directories;
    private static int links;

    public static void main(String[] args) {
        try {
            long startTime = System.currentTimeMillis();
            File root = new File("../target/site/apidocs").getCanonicalFile();
            Console.info("Checking links in {0}", root);
            DocLinkTester.process(root);
            Console.info("Checked {0} links in {1} files in {2} directories in {3}ms", links, files, directories, System.currentTimeMillis() - startTime);
            if (errors == 0) {
                Console.info("No link errors", new Object[0]);
            } else {
                Console.error(errors + " errors", new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void process(File dir) throws Exception {
        if (dir.isDirectory()) {
            for (File fc : dir.listFiles()) {
                if (!fc.isFile() || !fc.getName().endsWith(".html")) continue;
                ++files;
                DocLinkTester.resolveLinks(fc);
            }
            for (File fc : dir.listFiles()) {
                if (!fc.isDirectory() || fc.getName().equals("src-html")) continue;
                ++directories;
                DocLinkTester.process(fc);
            }
        }
    }

    private static boolean hasAnchor(File f, String anchor) throws Exception {
        String key = f.getCanonicalPath();
        if (!ANCHORS.containsKey(key)) {
            HashSet<String> s = new HashSet<String>();
            String c2 = IOUtils.read(f);
            Matcher m2 = p2.matcher(c2);
            while (m2.find()) {
                s.add(m2.group(2));
            }
            ANCHORS.put(key, s);
        }
        return ANCHORS.get(key).contains(anchor);
    }

    private static void resolveLinks(File f) throws Exception {
        String contents = IOUtils.read(f);
        Matcher m = p.matcher(contents);
        while (m.find()) {
            File f2;
            String link = m.group(2);
            String anchor = null;
            if (link.startsWith("https://") || link.startsWith("http://") || link.startsWith("mailto:") || link.startsWith("javascript:") || link.startsWith("$")) continue;
            ++links;
            if (link.indexOf(63) != -1) {
                link = link.substring(0, link.indexOf(63));
            }
            if (link.indexOf(35) != -1) {
                anchor = link.substring(link.lastIndexOf(35) + 1);
                link = link.substring(0, link.lastIndexOf(35));
            }
            File file = f2 = link.isEmpty() ? f : new File(f.getParentFile().getAbsolutePath() + "/" + link);
            if (!f2.exists()) {
                DocLinkTester.error(f, "missingLink=[" + link + "]");
                continue;
            }
            if (anchor == null) continue;
            if (f2.isFile()) {
                boolean foundAnchor = DocLinkTester.hasAnchor(f2, anchor);
                if (foundAnchor) continue;
                DocLinkTester.error(f, "missingAnchor=[" + link + "#" + anchor + "]");
                continue;
            }
            DocLinkTester.error(f, "invalidAnchor=[" + link + "#" + anchor + "]");
        }
    }

    private static void error(File f, String msg) {
        ++errors;
        Console.error("{0}: {1}", f.getAbsolutePath(), msg);
    }
}

