/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.xmlrpc;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.wiki.LinkCollector;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiPage;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.xmlrpc.AbstractRPCHandler;
import org.apache.xmlrpc.XmlRpcException;

public class RPCHandler
extends AbstractRPCHandler {
    private static Logger log = Logger.getLogger(RPCHandler.class);

    @Override
    public void initialize(WikiContext ctx) {
        super.initialize(ctx);
    }

    private String toRPCString(String src) {
        return TextUtil.urlEncodeUTF8(src);
    }

    private String fromRPCString(String src) {
        return TextUtil.urlDecodeUTF8(src);
    }

    private byte[] toRPCBase64(String src) {
        try {
            return src.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.fatal((Object)"Platform does not support UTF-8, reverting to platform default");
            return src.getBytes();
        }
    }

    public String getApplicationName() {
        this.checkPermission(PagePermission.VIEW);
        return this.toRPCString(this.m_engine.getApplicationName());
    }

    public Vector getAllPages() {
        this.checkPermission(PagePermission.VIEW);
        Collection pages = this.m_engine.getRecentChanges();
        Vector<String> result = new Vector<String>();
        for (WikiPage p : pages) {
            if (p instanceof Attachment) continue;
            result.add(this.toRPCString(p.getName()));
        }
        return result;
    }

    @Override
    protected Hashtable<String, Object> encodeWikiPage(WikiPage page) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("name", this.toRPCString(page.getName()));
        Date d = page.getLastModified();
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.add(14, -(cal.get(15) + (cal.getTimeZone().inDaylightTime(d) ? cal.get(16) : 0)));
        ht.put("lastModified", cal.getTime());
        ht.put("version", page.getVersion());
        if (page.getAuthor() != null) {
            ht.put("author", this.toRPCString(page.getAuthor()));
        }
        return ht;
    }

    @Override
    public Vector getRecentChanges(Date since) {
        this.checkPermission(PagePermission.VIEW);
        Collection pages = this.m_engine.getRecentChanges();
        Vector<Hashtable<String, Object>> result = new Vector<Hashtable<String, Object>>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(since);
        cal.add(14, cal.get(15) + (cal.getTimeZone().inDaylightTime(since) ? cal.get(16) : 0));
        since = cal.getTime();
        for (WikiPage page : pages) {
            if (!page.getLastModified().after(since) || page instanceof Attachment) continue;
            result.add(this.encodeWikiPage(page));
        }
        return result;
    }

    private String parsePageCheckCondition(String pagename) throws XmlRpcException {
        if (!this.m_engine.pageExists(pagename = this.fromRPCString(pagename))) {
            throw new XmlRpcException(1, "No such page '" + pagename + "' found, o master.");
        }
        WikiPage p = this.m_engine.getPage(pagename);
        this.checkPermission(PermissionFactory.getPagePermission(p, "view"));
        return pagename;
    }

    public Hashtable getPageInfo(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(this.m_engine.getPage(pagename));
    }

    public Hashtable getPageInfoVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.encodeWikiPage(this.m_engine.getPage(pagename, version));
    }

    public byte[] getPage(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        String text = this.m_engine.getPureText(pagename, -1);
        return this.toRPCBase64(text);
    }

    public byte[] getPageVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.toRPCBase64(this.m_engine.getPureText(pagename, version));
    }

    public byte[] getPageHTML(String pagename) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.toRPCBase64(this.m_engine.getHTML(pagename));
    }

    public byte[] getPageHTMLVersion(String pagename, int version) throws XmlRpcException {
        pagename = this.parsePageCheckCondition(pagename);
        return this.toRPCBase64(this.m_engine.getHTML(pagename, version));
    }

    public Vector listLinks(String pagename) throws XmlRpcException {
        Hashtable<String, String> ht;
        pagename = this.parsePageCheckCondition(pagename);
        WikiPage page = this.m_engine.getPage(pagename);
        String pagedata = this.m_engine.getPureText(page);
        LinkCollector localCollector = new LinkCollector();
        LinkCollector extCollector = new LinkCollector();
        LinkCollector attCollector = new LinkCollector();
        WikiContext context = new WikiContext(this.m_engine, page);
        context.setVariable("jspwiki.referenceStyle", "absolute");
        this.m_engine.textToHTML(context, pagedata, localCollector, extCollector, attCollector);
        Vector result = new Vector();
        for (String link : localCollector.getLinks()) {
            ht = new Hashtable<String, String>();
            ht.put("page", this.toRPCString(link));
            ht.put("type", "local");
            if (this.m_engine.pageExists(link)) {
                ht.put("href", context.getURL(WikiContext.VIEW, link));
            } else {
                ht.put("href", context.getURL(WikiContext.EDIT, link));
            }
            result.add(ht);
        }
        for (String link : attCollector.getLinks()) {
            ht = new Hashtable();
            ht.put("page", this.toRPCString(link));
            ht.put("type", "local");
            ht.put("href", context.getURL(WikiContext.ATTACH, link));
            result.add(ht);
        }
        for (String link : extCollector.getLinks()) {
            ht = new Hashtable();
            ht.put("page", link);
            ht.put("type", "external");
            ht.put("href", link);
            result.add(ht);
        }
        return result;
    }
}

