/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.progress;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.wiki.ajax.WikiAjaxDispatcherServlet;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.ui.progress.ProgressItem;

public class ProgressManager {
    private Map<String, ProgressItem> m_progressingTasks = new HashMap<String, ProgressItem>();
    public static final String JSON_PROGRESSTRACKER = "progressTracker";
    private static Logger log = Logger.getLogger(ProgressManager.class);

    public ProgressManager() {
        WikiAjaxDispatcherServlet.registerServlet(JSON_PROGRESSTRACKER, new JSONTracker());
    }

    public String getNewProgressIdentifier() {
        return UUID.randomUUID().toString();
    }

    public void startProgress(ProgressItem pi, String id) {
        log.debug((Object)("Adding " + id + " to progress queue"));
        this.m_progressingTasks.put(id, pi);
        pi.setState(1);
    }

    public void stopProgress(String id) {
        log.debug((Object)("Removed " + id + " from progress queue"));
        ProgressItem pi = this.m_progressingTasks.remove(id);
        if (pi != null) {
            pi.setState(2);
        }
    }

    public int getProgress(String id) throws IllegalArgumentException {
        ProgressItem pi = this.m_progressingTasks.get(id);
        if (pi != null) {
            return pi.getProgress();
        }
        throw new IllegalArgumentException("No such id was found");
    }

    public class JSONTracker
    implements WikiAjaxServlet {
        public int getProgress(String progressId) {
            return ProgressManager.this.getProgress(progressId);
        }

        @Override
        public String getServletMapping() {
            return ProgressManager.JSON_PROGRESSTRACKER;
        }

        @Override
        public void service(HttpServletRequest req, HttpServletResponse resp, String actionName, List<String> params) throws ServletException, IOException {
            log.debug((Object)"ProgressManager.doGet() START");
            if (params.size() < 1) {
                return;
            }
            String progressId = params.get(0);
            log.debug((Object)("progressId=" + progressId));
            String progressString = "";
            try {
                int progress = this.getProgress(progressId);
                progressString = Integer.toString(progress);
            }
            catch (IllegalArgumentException e) {
                log.debug((Object)("progressId " + progressId + " is no longer valid"));
            }
            log.debug((Object)("progressString=" + progressString));
            resp.getWriter().write(progressString);
            log.debug((Object)"ProgressManager.doGet() DONE");
        }
    }
}

