/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ui.admin;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.lang.StringUtils;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.management.SimpleMBean;
import org.apache.wiki.ui.admin.AdminBean;

public abstract class SimpleAdminBean
extends SimpleMBean
implements AdminBean {
    protected WikiEngine m_engine;

    protected SimpleAdminBean() throws NotCompliantMBeanException {
    }

    @Override
    public void initialize(WikiEngine engine) {
        this.m_engine = engine;
    }

    @Override
    public String doGet(WikiContext context) {
        MBeanInfo info = this.getMBeanInfo();
        MBeanAttributeInfo[] attributes = info.getAttributes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < attributes.length; ++i) {
            sb.append("<div class='block'>\n");
            sb.append("<label>" + StringUtils.capitalize((String)attributes[i].getName()) + "</label>\n");
            try {
                Object value = this.getAttribute(attributes[i].getName());
                if (attributes[i].isWritable()) {
                    sb.append("<input type='text' name='question' size='30' value='" + value + "' />\n");
                } else {
                    sb.append("<input type='text' class='readonly' readonly='true' size='30' value='" + value + "' />\n");
                }
            }
            catch (Exception e) {
                sb.append("Exception: " + e.getMessage());
            }
            sb.append("<div class='description'>" + attributes[i].getDescription() + "</div>\n");
            sb.append("</div>\n");
        }
        return sb.toString();
    }

    @Override
    public String doPost(WikiContext context) {
        return null;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }
}

