/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiPage;

public abstract class IteratorTag
extends BodyTagSupport
implements TryCatchFinally {
    private static final long serialVersionUID = 8945334759300595321L;
    protected String m_pageName;
    protected Iterator m_iterator;
    protected WikiContext m_wikiContext;
    private static final Logger log = Logger.getLogger(IteratorTag.class);

    public void setList(Collection arg) {
        if (arg != null) {
            this.m_iterator = arg.iterator();
        }
    }

    public void setList(Object[] arg) {
        if (arg != null) {
            this.m_iterator = Arrays.asList(arg).iterator();
        }
    }

    public void clearList() {
        this.m_iterator = null;
    }

    public void resetIterator() {
    }

    public int doStartTag() {
        this.m_wikiContext = WikiContext.findContext(this.pageContext);
        this.resetIterator();
        if (this.m_iterator == null) {
            return 0;
        }
        if (this.m_iterator.hasNext()) {
            this.buildContext();
        }
        return 2;
    }

    private void buildContext() {
        WikiContext context = (WikiContext)this.m_wikiContext.clone();
        Object o = this.m_iterator.next();
        if (o instanceof WikiPage) {
            context.setPage((WikiPage)o);
        }
        this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
        this.pageContext.setAttribute(this.getId(), o);
    }

    public int doEndTag() {
        this.pageContext.setAttribute("jspwiki.context", (Object)this.m_wikiContext, 2);
        return 6;
    }

    public int doAfterBody() {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (IOException e) {
                log.error((Object)"Unable to get inner tag text", (Throwable)e);
            }
        }
        if (this.m_iterator != null && this.m_iterator.hasNext()) {
            this.buildContext();
            return 2;
        }
        return 0;
    }

    public void doCatch(Throwable arg0) throws Throwable {
    }

    public void doFinally() {
        this.resetIterator();
        this.m_iterator = null;
        this.m_pageName = null;
        this.m_wikiContext = null;
    }
}

