/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.tags.WikiTagBase;

public class InsertPageTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logger.getLogger(InsertPageTag.class);
    public static final int HTML = 0;
    public static final int PLAIN = 1;
    protected String m_pageName = null;
    private int m_mode = 0;

    @Override
    public void initTag() {
        super.initTag();
        this.m_pageName = null;
        this.m_mode = 0;
    }

    public void setPage(String page) {
        this.m_pageName = page;
    }

    public String getPage() {
        return this.m_pageName;
    }

    public void setMode(String arg) {
        this.m_mode = "plain".equals(arg) ? 1 : 0;
    }

    @Override
    public final int doWikiStartTag() throws IOException, ProviderException {
        WikiPage insertedPage;
        WikiEngine engine = this.m_wikiContext.getEngine();
        if (this.m_pageName == null) {
            insertedPage = this.m_wikiContext.getPage();
            if (!engine.pageExists(insertedPage)) {
                return 0;
            }
        } else {
            insertedPage = engine.getPage(this.m_pageName);
        }
        if (insertedPage != null) {
            log.debug((Object)("Inserting page " + insertedPage));
            JspWriter out = this.pageContext.getOut();
            WikiPage oldPage = this.m_wikiContext.setRealPage(insertedPage);
            switch (this.m_mode) {
                case 0: {
                    out.print(engine.getHTML(this.m_wikiContext, insertedPage));
                    break;
                }
                case 1: {
                    out.print(engine.getText(this.m_wikiContext, insertedPage));
                }
            }
            this.m_wikiContext.setRealPage(oldPage);
        }
        return 0;
    }
}

