/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.tags.WikiTagBase;

public class InsertDiffTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logger.getLogger(InsertDiffTag.class);
    public static final String ATTR_OLDVERSION = "olddiff";
    public static final String ATTR_NEWVERSION = "newdiff";
    protected String m_pageName;

    @Override
    public void initTag() {
        super.initTag();
        this.m_pageName = null;
    }

    public void setPage(String page) {
        this.m_pageName = page;
    }

    public String getPage() {
        return this.m_pageName;
    }

    @Override
    public final int doWikiStartTag() throws IOException {
        WikiContext ctx;
        WikiEngine engine = this.m_wikiContext.getEngine();
        if (this.m_pageName == null) {
            ctx = this.m_wikiContext;
        } else {
            ctx = (WikiContext)this.m_wikiContext.clone();
            ctx.setPage(engine.getPage(this.m_pageName));
        }
        Integer vernew = (Integer)this.pageContext.getAttribute(ATTR_NEWVERSION, 2);
        Integer verold = (Integer)this.pageContext.getAttribute(ATTR_OLDVERSION, 2);
        log.debug((Object)("Request diff between version " + verold + " and " + vernew));
        if (ctx.getPage() != null) {
            JspWriter out = this.pageContext.getOut();
            String diff = engine.getDiff(ctx, vernew, verold);
            if (diff.length() == 0) {
                return 1;
            }
            out.write(diff);
        }
        return 0;
    }
}

