/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.List;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.tags.IteratorTag;

public class HistoryIteratorTag
extends IteratorTag {
    private static final long serialVersionUID = 0L;
    static Logger log = Logger.getLogger(HistoryIteratorTag.class);

    @Override
    public final int doStartTag() {
        this.m_wikiContext = (WikiContext)this.pageContext.getAttribute("jspwiki.context", 2);
        WikiEngine engine = this.m_wikiContext.getEngine();
        WikiPage page = this.m_wikiContext.getPage();
        try {
            if (page != null && engine.pageExists(page)) {
                List versions = engine.getVersionHistory(page.getName());
                if (versions == null) {
                    return 0;
                }
                this.m_iterator = versions.iterator();
                if (this.m_iterator.hasNext()) {
                    WikiContext context = (WikiContext)this.m_wikiContext.clone();
                    context.setPage((WikiPage)this.m_iterator.next());
                    this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
                    this.pageContext.setAttribute(this.getId(), (Object)context.getPage());
                } else {
                    return 0;
                }
            }
            return 2;
        }
        catch (ProviderException e) {
            log.fatal((Object)"Provider failed while trying to iterator through history", (Throwable)e);
            return 0;
        }
    }

    @Override
    public final int doAfterBody() {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (IOException e) {
                log.error((Object)"Unable to get inner tag text", (Throwable)e);
            }
        }
        if (this.m_iterator != null && this.m_iterator.hasNext()) {
            WikiContext context = (WikiContext)this.m_wikiContext.clone();
            context.setPage((WikiPage)this.m_iterator.next());
            this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
            this.pageContext.setAttribute(this.getId(), (Object)context.getPage());
            return 2;
        }
        return 0;
    }
}

