/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.tags.WikiTagBase;

public class ContentTag
extends WikiTagBase {
    private static final long serialVersionUID = 0L;
    private static final Logger log = Logger.getLogger(ContentTag.class);
    private Map<String, String> m_mappings = new HashMap<String, String>();

    public void setView(String s) {
        this.m_mappings.put(WikiContext.VIEW, s);
    }

    public void setDiff(String s) {
        this.m_mappings.put(WikiContext.DIFF, s);
    }

    public void setInfo(String s) {
        this.m_mappings.put(WikiContext.INFO, s);
    }

    public void setPreview(String s) {
        this.m_mappings.put(WikiContext.PREVIEW, s);
    }

    public void setConflict(String s) {
        this.m_mappings.put(WikiContext.CONFLICT, s);
    }

    public void setFind(String s) {
        this.m_mappings.put(WikiContext.FIND, s);
    }

    public void setPrefs(String s) {
        this.m_mappings.put(WikiContext.PREFS, s);
    }

    public void setError(String s) {
        this.m_mappings.put(WikiContext.ERROR, s);
    }

    public void setEdit(String s) {
        this.m_mappings.put(WikiContext.EDIT, s);
    }

    public void setComment(String s) {
        this.m_mappings.put(WikiContext.COMMENT, s);
    }

    @Override
    public final int doWikiStartTag() throws IOException, ProviderException {
        return 0;
    }

    @Override
    public final int doEndTag() throws JspException {
        try {
            String requestContext = this.m_wikiContext.getRequestContext();
            String contentTemplate = this.m_mappings.get(requestContext);
            if (contentTemplate == null) {
                contentTemplate = this.m_wikiContext.getContentTemplate();
            }
            if (contentTemplate == null) {
                throw new JspException("This template uses <wiki:Content/> in an unsupported context: " + requestContext);
            }
            String page = this.m_wikiContext.getEngine().getTemplateManager().findJSP(this.pageContext, this.m_wikiContext.getTemplate(), contentTemplate);
            this.pageContext.include(page);
        }
        catch (ServletException e) {
            log.warn((Object)"Including failed, got a servlet exception from sub-page. Rethrowing the exception to the JSP engine.", (Throwable)e);
            throw new JspException(e.getMessage());
        }
        catch (IOException e) {
            log.warn((Object)"I/O exception - probably the connection was broken. Rethrowing the exception to the JSP engine.", (Throwable)e);
            throw new JspException(e.getMessage());
        }
        return 6;
    }
}

