/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.jsp.JspWriter;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.tags.IteratorTag;

public class AttachmentsIteratorTag
extends IteratorTag {
    private static final long serialVersionUID = 0L;
    static Logger log = Logger.getLogger(AttachmentsIteratorTag.class);

    @Override
    public final int doStartTag() {
        this.m_wikiContext = (WikiContext)this.pageContext.getAttribute("jspwiki.context", 2);
        WikiEngine engine = this.m_wikiContext.getEngine();
        AttachmentManager mgr = engine.getAttachmentManager();
        WikiPage page = this.m_wikiContext.getPage();
        if (!mgr.attachmentsEnabled()) {
            return 0;
        }
        try {
            if (page != null && engine.pageExists(page)) {
                Collection atts = mgr.listAttachments(page);
                if (atts == null) {
                    log.debug((Object)"No attachments to display.");
                    return 0;
                }
                this.m_iterator = atts.iterator();
                if (!this.m_iterator.hasNext()) {
                    return 0;
                }
            } else {
                return 0;
            }
            Attachment att = (Attachment)this.m_iterator.next();
            WikiContext context = (WikiContext)this.m_wikiContext.clone();
            context.setPage(att);
            this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
            this.pageContext.setAttribute(this.getId(), (Object)att);
            return 2;
        }
        catch (ProviderException e) {
            log.fatal((Object)"Provider failed while trying to iterator through history", (Throwable)e);
            return 0;
        }
    }

    @Override
    public final int doAfterBody() {
        if (this.bodyContent != null) {
            try {
                JspWriter out = this.getPreviousOut();
                out.print(this.bodyContent.getString());
                this.bodyContent.clearBody();
            }
            catch (IOException e) {
                log.error((Object)"Unable to get inner tag text", (Throwable)e);
            }
        }
        if (this.m_iterator != null && this.m_iterator.hasNext()) {
            Attachment att = (Attachment)this.m_iterator.next();
            WikiContext context = (WikiContext)this.m_wikiContext.clone();
            context.setPage(att);
            this.pageContext.setAttribute("jspwiki.context", (Object)context, 2);
            this.pageContext.setAttribute(this.getId(), (Object)att);
            return 2;
        }
        return 0;
    }
}

