/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.rss;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.apache.wiki.WatchDog;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.rss.RSSGenerator;
import org.apache.wiki.util.FileUtil;

public class RSSThread
extends WikiBackgroundThread {
    static Logger log = Logger.getLogger(RSSThread.class);
    private final File m_rssFile;
    private final RSSGenerator m_generator;
    private WatchDog m_watchdog;

    public RSSThread(WikiEngine engine, File rssFile, int rssInterval) {
        super(engine, rssInterval);
        this.m_generator = engine.getRSSGenerator();
        this.m_rssFile = rssFile;
        this.setName("JSPWiki RSS Generator");
        log.debug((Object)("RSS file will be at " + this.m_rssFile.getAbsolutePath()));
        log.debug((Object)("RSS refresh interval (seconds): " + rssInterval));
    }

    @Override
    public void startupTask() throws Exception {
        this.m_watchdog = this.getEngine().getCurrentWatchDog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backgroundTask() throws Exception {
        if (this.m_generator.isEnabled()) {
            Writer out = null;
            Reader in = null;
            this.m_watchdog.enterState("Generating RSS feed", 60);
            try {
                log.debug((Object)("Regenerating RSS feed to " + this.m_rssFile));
                String feed = this.m_generator.generate();
                in = new StringReader(feed);
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_rssFile), "UTF-8"));
                FileUtil.copyContents(in, out);
            }
            catch (IOException e) {
                log.error((Object)("Cannot generate RSS feed to " + this.m_rssFile.getAbsolutePath()), (Throwable)e);
                this.m_generator.setEnabled(false);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    log.fatal((Object)"Could not close I/O for RSS", (Throwable)e);
                    this.m_generator.setEnabled(false);
                }
                this.m_watchdog.exitState();
            }
        }
    }
}

