/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.preferences;

import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.i18n.InternationalizationManager;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.PropertyReader;
import org.apache.wiki.util.TextUtil;

public class Preferences
extends HashMap<String, String> {
    private static final long serialVersionUID = 1L;
    public static final String SESSIONPREFS = "prefs";
    private static Logger log = Logger.getLogger(Preferences.class);

    public static void setupPreferences(PageContext pageContext) {
        Preferences.reloadPreferences(pageContext);
    }

    public static void reloadPreferences(PageContext pageContext) {
        Preferences prefs = new Preferences();
        Properties props = PropertyReader.loadWebAppProps(pageContext.getServletContext());
        WikiContext ctx = WikiContext.findContext(pageContext);
        prefs.put("SkinName", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.skinname", "PlainVanilla"));
        prefs.put("DateFormat", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.dateformat", ctx.getEngine().getInternationalizationManager().get("CoreResources", Preferences.getLocale(ctx), "common.datetimeformat")));
        prefs.put("TimeZone", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.timezone", TimeZone.getDefault().getID()));
        prefs.put("Orientation", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.orientation", "fav-left"));
        prefs.put("Sidebar", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.sidebar", "active"));
        prefs.put("Layout", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.layout", "fluid"));
        prefs.put("Language", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.language", Preferences.getLocale(ctx).toString()));
        prefs.put("SectionEditing", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.sectionediting", "true"));
        prefs.put("editor", TextUtil.getStringProperty(props, "jspwiki.defaultprefs.template.editor", "plain"));
        Preferences.parseJSONPreferences((HttpServletRequest)pageContext.getRequest(), prefs);
        pageContext.getSession().setAttribute(SESSIONPREFS, (Object)prefs);
    }

    private static void parseJSONPreferences(HttpServletRequest request, Preferences prefs) {
        String prefVal = TextUtil.urlDecodeUTF8(HttpUtil.retrieveCookieValue(request, "JSPWikiUserPrefs"));
        if (prefVal != null) {
            Gson gson = new Gson();
            Map map = new HashMap();
            map = (Map)gson.fromJson(prefVal, map.getClass());
            for (String key : map.keySet()) {
                Object value = map.get(key = TextUtil.replaceEntities(key));
                if (value == null) continue;
                prefs.put(key, value.toString());
            }
        }
    }

    public static String getPreference(WikiContext wikiContext, String name) {
        HttpServletRequest request = wikiContext.getHttpRequest();
        if (request == null) {
            return null;
        }
        Preferences prefs = (Preferences)request.getSession().getAttribute(SESSIONPREFS);
        if (prefs != null) {
            return (String)prefs.get(name);
        }
        return null;
    }

    public static String getPreference(PageContext pageContext, String name) {
        Preferences prefs = (Preferences)pageContext.getSession().getAttribute(SESSIONPREFS);
        if (prefs != null) {
            return (String)prefs.get(name);
        }
        return null;
    }

    public static Locale getLocale(WikiContext context) {
        Locale loc = null;
        String langSetting = Preferences.getPreference(context, "Language");
        if (langSetting != null) {
            String language = "";
            String country = "";
            String variant = "";
            String[] res = StringUtils.split((String)langSetting, (String)"-_");
            if (res.length > 2) {
                variant = res[2];
            }
            if (res.length > 1) {
                country = res[1];
            }
            if (res.length > 0) {
                language = res[0];
                loc = new Locale(language, country, variant);
            }
        }
        if (loc == null) {
            HttpServletRequest request = context.getHttpRequest();
            loc = request != null ? request.getLocale() : Locale.getDefault();
        }
        return loc;
    }

    public static ResourceBundle getBundle(WikiContext context, String bundle) throws MissingResourceException {
        Locale loc = Preferences.getLocale(context);
        InternationalizationManager i18n = context.getEngine().getInternationalizationManager();
        return i18n.getBundle(bundle, loc);
    }

    public static SimpleDateFormat getDateFormat(WikiContext context, TimeFormat tf) {
        String prefDateFormat;
        InternationalizationManager imgr = context.getEngine().getInternationalizationManager();
        Locale clientLocale = Preferences.getLocale(context);
        String prefTimeZone = Preferences.getPreference(context, "TimeZone");
        log.debug((Object)"Checking for preferences...");
        switch (tf) {
            case DATETIME: {
                prefDateFormat = Preferences.getPreference(context, "DateFormat");
                log.debug((Object)("Preferences fmt = " + prefDateFormat));
                if (prefDateFormat != null) break;
                prefDateFormat = imgr.get("CoreResources", clientLocale, "common.datetimeformat");
                log.debug((Object)("Using locale-format = " + prefDateFormat));
                break;
            }
            case TIME: {
                prefDateFormat = imgr.get("common.timeformat");
                break;
            }
            case DATE: {
                prefDateFormat = imgr.get("common.dateformat");
                break;
            }
            default: {
                throw new InternalWikiException("Got a TimeFormat for which we have no value!");
            }
        }
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(prefDateFormat, clientLocale);
            if (prefTimeZone != null) {
                TimeZone tz = TimeZone.getTimeZone(prefTimeZone);
                fmt.setTimeZone(tz);
            }
            return fmt;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String renderDate(WikiContext context, Date date, TimeFormat tf) {
        SimpleDateFormat df = Preferences.getDateFormat(context, tf);
        return df.format(date);
    }

    public static enum TimeFormat {
        TIME,
        DATE,
        DATETIME;

    }
}

