/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.plugin.WeblogPlugin;
import org.apache.wiki.util.TextUtil;

public class WeblogArchivePlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger(WeblogArchivePlugin.class);
    public static final String PARAM_PAGE = "page";
    private SimpleDateFormat m_monthUrlFormat;

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        WikiEngine engine = context.getEngine();
        String weblogName = params.get(PARAM_PAGE);
        if (weblogName == null) {
            weblogName = context.getPage().getName();
        }
        this.m_monthUrlFormat = new SimpleDateFormat("'" + context.getURL(WikiContext.VIEW, weblogName, "weblog.startDate='ddMMyy'&amp;weblog.days=%d") + "'");
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"weblogarchive\">\n");
        try {
            SortedSet<Calendar> months = this.collectMonths(engine, weblogName);
            int year = 0;
            sb.append("<ul>\n");
            if (months.size() > 0) {
                year = ((Calendar)months.iterator().next()).get(1);
                sb.append("<li class=\"archiveyear\">" + year + "</li>\n");
            }
            for (Calendar cal : months) {
                if (cal.get(1) != year) {
                    year = cal.get(1);
                    sb.append("<li class=\"archiveyear\">" + year + "</li>\n");
                }
                sb.append("  <li>");
                sb.append(this.getMonthLink(cal));
                sb.append("</li>\n");
            }
            sb.append("</ul>\n");
        }
        catch (ProviderException ex) {
            log.info((Object)"Cannot get archive", (Throwable)ex);
            sb.append("Cannot get archive: " + ex.getMessage());
        }
        sb.append("</div>\n");
        return sb.toString();
    }

    private SortedSet<Calendar> collectMonths(WikiEngine engine, String page) throws ProviderException {
        ArchiveComparator comp = new ArchiveComparator();
        TreeSet<Calendar> res = new TreeSet<Calendar>(comp);
        WeblogPlugin pl = new WeblogPlugin();
        List blogEntries = pl.findBlogEntries(engine, page, new Date(0L), new Date());
        for (WikiPage p : blogEntries) {
            Date d = p.getLastModified();
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            res.add(cal);
        }
        return res;
    }

    private String getMonthLink(Calendar day) {
        String result;
        SimpleDateFormat monthfmt = new SimpleDateFormat("MMMM");
        if (this.m_monthUrlFormat == null) {
            result = monthfmt.format(day.getTime());
        } else {
            Calendar cal = (Calendar)day.clone();
            int firstDay = cal.getActualMinimum(5);
            int lastDay = cal.getActualMaximum(5);
            cal.set(5, lastDay);
            String url = this.m_monthUrlFormat.format(cal.getTime());
            url = TextUtil.replaceString(url, "%d", Integer.toString(lastDay - firstDay + 1));
            result = "<a href=\"" + url + "\">" + monthfmt.format(cal.getTime()) + "</a>";
        }
        return result;
    }

    private static class ArchiveComparator
    implements Comparator<Calendar> {
        private ArchiveComparator() {
        }

        @Override
        public int compare(Calendar a, Calendar b) {
            if (a == null || b == null) {
                throw new ClassCastException("Invalid calendar supplied for comparison.");
            }
            if (a.get(1) == b.get(1) && a.get(2) == b.get(2)) {
                return 0;
            }
            return b.getTime().before(a.getTime()) ? -1 : 1;
        }
    }
}

