/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.wiki.ReferenceManager;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.plugin.AbstractReferralPlugin;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.TextUtil;

public class ReferringUndefinedPagesPlugin
extends AbstractReferralPlugin {
    private static Logger log = Logger.getLogger(ReferringUndefinedPagesPlugin.class);
    public static final String PARAM_MAX = "max";
    public static final String PARAM_EXTRAS = "extras";

    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        ReferenceManager referenceManager = context.getEngine().getReferenceManager();
        int items = TextUtil.parseIntParameter(params.get(PARAM_MAX), -1);
        String extras = params.get(PARAM_EXTRAS);
        if (extras == null) {
            extras = rb.getString("referringundefinedpagesplugin.more");
        }
        StringBuilder resultHTML = new StringBuilder();
        Collection uncreatedPages = referenceManager.findUncreated();
        super.initialize(context, params);
        Set result = null;
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        if (uncreatedPages != null) {
            for (String uncreatedPageName : uncreatedPages) {
                Collection referrers = referenceManager.findReferrers(uncreatedPageName);
                if (referrers == null) continue;
                for (String referringPage : referrers) {
                    sortedMap.put(referringPage, "");
                }
            }
            result = sortedMap.keySet();
        }
        result = super.filterAndSortCollection(result);
        String wikitext = this.wikitizeCollection(result, this.m_separator, items);
        resultHTML.append(this.makeHTML(context, wikitext));
        if (items < result.size() && items > 0) {
            Object[] args = new Object[]{"" + (result.size() - items)};
            extras = MessageFormat.format(extras, args);
            resultHTML.append("<br/>" + extras + "<br/>");
        }
        return resultHTML.toString();
    }
}

