/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.PageLock;
import org.apache.wiki.PageManager;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.preferences.Preferences;

public class ListLocksPlugin
implements WikiPlugin {
    @Override
    public String execute(WikiContext context, Map<String, String> params) throws PluginException {
        StringBuilder result = new StringBuilder();
        PageManager mgr = context.getEngine().getPageManager();
        List<PageLock> locks = mgr.getActiveLocks();
        ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
        result.append("<table class=\"wikitable\">\n");
        result.append("<tr>\n");
        result.append("<th>" + rb.getString("plugin.listlocks.page") + "</th><th>" + rb.getString("plugin.listlocks.locked.by") + "</th><th>" + rb.getString("plugin.listlocks.acquired") + "</th><th>" + rb.getString("plugin.listlocks.expires") + "</th>\n");
        result.append("</tr>");
        if (locks.size() == 0) {
            result.append("<tr><td colspan=\"4\" class=\"odd\">" + rb.getString("plugin.listlocks.no.locks.exist") + "</td></tr>\n");
        } else {
            int rowNum = 1;
            for (PageLock lock : locks) {
                result.append(rowNum % 2 != 0 ? "<tr class=\"odd\">" : "<tr>");
                result.append("<td>" + lock.getPage() + "</td>");
                result.append("<td>" + lock.getLocker() + "</td>");
                result.append("<td>" + Preferences.renderDate(context, lock.getAcquisitionTime(), Preferences.TimeFormat.DATETIME) + "</td>");
                result.append("<td>" + Preferences.renderDate(context, lock.getExpiryTime(), Preferences.TimeFormat.DATETIME) + "</td>");
                result.append("</tr>\n");
                ++rowNum;
            }
        }
        result.append("</table>");
        return result.toString();
    }
}

