/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.plugin;

import java.io.IOException;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.PageSorter;
import org.apache.wiki.StringTransmutator;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.render.RenderingManager;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.util.comparators.CollatorComparator;
import org.apache.wiki.util.comparators.HumanComparator;
import org.apache.wiki.util.comparators.JavaNaturalComparator;
import org.apache.wiki.util.comparators.LocaleComparator;

public abstract class AbstractReferralPlugin
implements WikiPlugin {
    private static Logger log = Logger.getLogger(AbstractReferralPlugin.class);
    public static final int ALL_ITEMS = -1;
    public static final String PARAM_MAXWIDTH = "maxwidth";
    public static final String PARAM_SEPARATOR = "separator";
    public static final String PARAM_AFTER = "after";
    public static final String PARAM_BEFORE = "before";
    public static final String PARAM_EXCLUDE = "exclude";
    public static final String PARAM_INCLUDE = "include";
    public static final String PARAM_SHOW = "show";
    public static final String PARAM_SHOW_VALUE_PAGES = "pages";
    public static final String PARAM_SHOW_VALUE_COUNT = "count";
    public static final String PARAM_LASTMODIFIED = "showLastModified";
    protected static final String PARAM_SORTORDER = "sortOrder";
    protected static final String PARAM_SORTORDER_HUMAN = "human";
    protected static final String PARAM_SORTORDER_JAVA = "java";
    protected static final String PARAM_SORTORDER_LOCALE = "locale";
    protected int m_maxwidth = Integer.MAX_VALUE;
    protected String m_before = "";
    protected String m_separator = "";
    protected String m_after = "\\\\";
    protected Pattern[] m_exclude;
    protected Pattern[] m_include;
    protected PageSorter m_sorter;
    protected String m_show = "pages";
    protected boolean m_lastModified = false;
    protected Date m_dateLastModified = new Date(0L);
    protected SimpleDateFormat m_dateFormat;
    protected WikiEngine m_engine;

    public void initialize(WikiContext context, Map<String, String> params) throws PluginException {
        int i;
        String[] ptrns;
        GlobCompiler pc;
        String s;
        this.m_dateFormat = Preferences.getDateFormat(context, Preferences.TimeFormat.DATETIME);
        this.m_engine = context.getEngine();
        this.m_maxwidth = TextUtil.parseIntParameter(params.get(PARAM_MAXWIDTH), Integer.MAX_VALUE);
        if (this.m_maxwidth < 0) {
            this.m_maxwidth = 0;
        }
        if ((s = params.get(PARAM_SEPARATOR)) != null) {
            this.m_separator = s;
            this.m_after = "";
        }
        if ((s = params.get(PARAM_BEFORE)) != null) {
            this.m_before = s;
        }
        if ((s = params.get(PARAM_AFTER)) != null) {
            this.m_after = s;
        }
        if ((s = params.get(PARAM_EXCLUDE)) != null) {
            try {
                pc = new GlobCompiler();
                ptrns = StringUtils.split((String)s, (String)",");
                this.m_exclude = new Pattern[ptrns.length];
                for (i = 0; i < ptrns.length; ++i) {
                    this.m_exclude[i] = pc.compile(ptrns[i]);
                }
            }
            catch (MalformedPatternException e) {
                throw new PluginException("Exclude-parameter has a malformed pattern: " + e.getMessage());
            }
        }
        if ((s = params.get(PARAM_INCLUDE)) != null) {
            try {
                pc = new GlobCompiler();
                ptrns = StringUtils.split((String)s, (String)",");
                this.m_include = new Pattern[ptrns.length];
                for (i = 0; i < ptrns.length; ++i) {
                    this.m_include[i] = pc.compile(ptrns[i]);
                }
            }
            catch (MalformedPatternException e) {
                throw new PluginException("Include-parameter has a malformed pattern: " + e.getMessage());
            }
        }
        if ((s = params.get(PARAM_SHOW)) != null && s.equalsIgnoreCase(PARAM_SHOW_VALUE_COUNT)) {
            this.m_show = PARAM_SHOW_VALUE_COUNT;
        }
        if ((s = params.get(PARAM_LASTMODIFIED)) != null && s.equalsIgnoreCase("true")) {
            if (this.m_show.equals(PARAM_SHOW_VALUE_COUNT)) {
                this.m_lastModified = true;
            } else {
                throw new PluginException("showLastModified=true is only valid if show=count is also specified");
            }
        }
        this.initSorter(context, params);
    }

    protected Collection filterCollection(Collection c) {
        ArrayList result = new ArrayList();
        Perl5Matcher pm = new Perl5Matcher();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            int j;
            boolean includeThis;
            String pageName = null;
            Object objectje = i.next();
            pageName = objectje instanceof WikiPage ? ((WikiPage)objectje).getName() : (String)objectje;
            boolean bl = includeThis = this.m_include == null;
            if (this.m_include != null) {
                for (j = 0; j < this.m_include.length; ++j) {
                    if (!pm.matches(pageName, this.m_include[j])) continue;
                    includeThis = true;
                    break;
                }
            }
            if (this.m_exclude != null) {
                for (j = 0; j < this.m_exclude.length; ++j) {
                    if (!pm.matches(pageName, this.m_exclude[j])) continue;
                    includeThis = false;
                    break;
                }
            }
            if (!includeThis) continue;
            if (objectje instanceof WikiPage) {
                result.add(objectje);
            } else {
                result.add(pageName);
            }
            WikiPage page = null;
            if (!this.m_lastModified || (page = this.m_engine.getPage(pageName)) == null) continue;
            Date lastModPage = page.getLastModified();
            if (log.isDebugEnabled()) {
                log.debug((Object)("lastModified Date of page " + pageName + " : " + this.m_dateLastModified));
            }
            if (!lastModPage.after(this.m_dateLastModified)) continue;
            this.m_dateLastModified = lastModPage;
        }
        return result;
    }

    protected Collection filterAndSortCollection(Collection c) {
        ArrayList result = (ArrayList)this.filterCollection(c);
        this.m_sorter.sortPages(result);
        return result;
    }

    protected String wikitizeCollection(Collection links, String separator, int numItems) {
        int count;
        if (links == null || links.isEmpty()) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        Iterator it = links.iterator();
        for (count = 0; it.hasNext() && (count < numItems || numItems == -1); ++count) {
            String value = (String)it.next();
            if (count > 0) {
                output.append(this.m_after);
                output.append(this.m_separator);
            }
            output.append(this.m_before);
            output.append("[" + this.m_engine.beautifyTitle(value) + "|" + value + "]");
        }
        if (count > 0) {
            output.append(this.m_after);
        }
        return output.toString();
    }

    protected String makeHTML(WikiContext context, String wikitext) {
        String result = "";
        RenderingManager mgr = this.m_engine.getRenderingManager();
        try {
            MarkupParser parser = mgr.getParser(context, wikitext);
            parser.addLinkTransmutator(new CutMutator(this.m_maxwidth));
            parser.enableImageInlining(false);
            WikiDocument doc = parser.parse();
            result = mgr.getHTML(context, doc);
        }
        catch (IOException e) {
            log.error((Object)"Failed to convert page data to HTML", (Throwable)e);
        }
        return result;
    }

    private void initSorter(WikiContext context, Map<String, String> params) {
        String order = params.get(PARAM_SORTORDER);
        if (order == null || order.length() == 0) {
            this.m_sorter = context.getEngine().getPageSorter();
        } else if (order.equalsIgnoreCase(PARAM_SORTORDER_JAVA)) {
            this.m_sorter = new PageSorter(JavaNaturalComparator.DEFAULT_JAVA_COMPARATOR);
        } else if (order.equalsIgnoreCase(PARAM_SORTORDER_LOCALE)) {
            this.m_sorter = new PageSorter(LocaleComparator.DEFAULT_LOCALE_COMPARATOR);
        } else if (order.equalsIgnoreCase(PARAM_SORTORDER_HUMAN)) {
            this.m_sorter = new PageSorter(HumanComparator.DEFAULT_HUMAN_COMPARATOR);
        } else {
            try {
                RuleBasedCollator collator = new RuleBasedCollator(order);
                collator.setStrength(0);
                this.m_sorter = new PageSorter(new CollatorComparator(collator));
            }
            catch (ParseException pe) {
                log.info((Object)"Failed to parse requested collator - using default ordering", (Throwable)pe);
                this.m_sorter = context.getEngine().getPageSorter();
            }
        }
    }

    private static class CutMutator
    implements StringTransmutator {
        private int m_length;

        public CutMutator(int length) {
            this.m_length = length;
        }

        @Override
        public String mutate(WikiContext context, String text) {
            if (text.length() > this.m_length) {
                return text.substring(0, this.m_length) + "...";
            }
            return text;
        }
    }
}

