/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.api.plugin.ParserStagePlugin;
import org.apache.wiki.api.plugin.WikiPlugin;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.parser.WikiDocument;
import org.apache.wiki.preferences.Preferences;
import org.jdom2.Text;

public class PluginContent
extends Text {
    private static final String BLANK = "";
    private static final String CMDLINE = "_cmdline";
    private static final String ELEMENT_BR = "<br/>";
    private static final String EMITTABLE_PLUGINS = "Image|FormOpen|FormClose|FormInput|FormTextarea|FormSelect";
    private static final String LINEBREAK = "\n";
    private static final String PLUGIN_START = "[{";
    private static final String PLUGIN_END = "}]";
    private static final String SPACE = " ";
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(PluginContent.class);
    private String m_pluginName;
    private Map<String, String> m_params;

    public PluginContent(String pluginName, Map<String, String> parameters) {
        this.m_pluginName = pluginName;
        this.m_params = parameters;
    }

    public String getPluginName() {
        return this.m_pluginName;
    }

    public String getParameter(String name) {
        return this.m_params.get(name);
    }

    public Map<String, String> getParameters() {
        return this.m_params;
    }

    public String getValue() {
        return this.getText();
    }

    public String getText() {
        WikiDocument doc = (WikiDocument)this.getDocument();
        if (doc == null) {
            return this.getPluginName();
        }
        WikiContext context = doc.getContext();
        if (context == null) {
            log.info((Object)"WikiContext garbage-collected, cannot proceed");
            return this.getPluginName();
        }
        return this.invoke(context);
    }

    public String invoke(WikiContext context) {
        String result;
        Boolean wysiwygVariable = (Boolean)context.getVariable("WYSIWYG_EDITOR_MODE");
        boolean wysiwygEditorMode = false;
        if (wysiwygVariable != null) {
            wysiwygEditorMode = wysiwygVariable;
        }
        try {
            if (wysiwygEditorMode && !this.m_pluginName.matches(EMITTABLE_PLUGINS)) {
                result = PLUGIN_START + this.m_pluginName + SPACE;
                String cmdLine = this.m_params.get(CMDLINE).replaceAll(LINEBREAK, ELEMENT_BR);
                result = result + cmdLine + PLUGIN_END;
            } else {
                Boolean b = (Boolean)context.getVariable("_PluginContent.execute");
                if (b != null && !b.booleanValue()) {
                    return BLANK;
                }
                WikiEngine engine = context.getEngine();
                HashMap<String, String> parsedParams = new HashMap<String, String>();
                for (Map.Entry<String, String> e : this.m_params.entrySet()) {
                    String val = e.getValue();
                    val = engine.getVariableManager().expandVariables(context, val);
                    parsedParams.put(e.getKey(), val);
                }
                Object pm = engine.getPluginManager();
                result = pm.execute(context, this.m_pluginName, parsedParams);
            }
        }
        catch (Exception e) {
            if (wysiwygEditorMode) {
                result = BLANK;
            }
            ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
            result = MarkupParser.makeError(MessageFormat.format(rb.getString("plugin.error.insertionfailed"), context.getRealPage().getWiki(), context.getRealPage().getName(), e.getMessage())).getText();
        }
        return result;
    }

    public void executeParse(WikiContext context) throws PluginException {
        Object pm = context.getEngine().getPluginManager();
        if (pm.pluginsEnabled()) {
            ResourceBundle rb = Preferences.getBundle(context, "plugin.PluginResources");
            Map<String, String> params = this.getParameters();
            WikiPlugin plugin = pm.newWikiPlugin(this.getPluginName(), rb);
            try {
                if (plugin != null && plugin instanceof ParserStagePlugin) {
                    ((ParserStagePlugin)((Object)plugin)).executeParser(this, context, params);
                }
            }
            catch (ClassCastException e) {
                throw new PluginException(MessageFormat.format(rb.getString("plugin.error.notawikiplugin"), this.getPluginName()), e);
            }
        }
    }

    public static PluginContent parsePluginLine(WikiContext context, String commandline, int pos) throws PluginException {
        Perl5Matcher matcher = new Perl5Matcher();
        try {
            Object pm = context.getEngine().getPluginManager();
            if (matcher.contains(commandline, pm.getPluginPattern())) {
                MatchResult res = matcher.getMatch();
                String plugin = res.group(2);
                String args = commandline.substring(res.endOffset(0), commandline.length() - (commandline.charAt(commandline.length() - 1) == '}' ? 1 : 0));
                Map<String, String> arglist = pm.parseArgs(args);
                if (pos != -1) {
                    int end = pos + commandline.length() + 2;
                    String bounds = pos + "|" + end;
                    arglist.put("_bounds", bounds);
                }
                PluginContent result = new PluginContent(plugin, arglist);
                return result;
            }
        }
        catch (ClassCastException e) {
            log.error((Object)"Invalid type offered in parsing plugin arguments.", (Throwable)e);
            throw new InternalWikiException("Oops, someone offered !String!", e);
        }
        catch (NoSuchElementException e) {
            String msg = "Missing parameter in plugin definition: " + commandline;
            log.warn((Object)msg, (Throwable)e);
            throw new PluginException(msg);
        }
        catch (IOException e) {
            String msg = "Zyrf.  Problems with parsing arguments: " + commandline;
            log.warn((Object)msg, (Throwable)e);
            throw new PluginException(msg);
        }
        return null;
    }
}

