/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.oro.text.GlobCompiler;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.wiki.StringTransmutator;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.parser.HeadingListener;
import org.apache.wiki.parser.LinkParsingOperations;
import org.apache.wiki.parser.WikiDocument;
import org.jdom2.Element;

public abstract class MarkupParser {
    protected static final int PUSHBACK_BUFFER_SIZE = 10240;
    protected PushbackReader m_in;
    private int m_pos = -1;
    protected WikiEngine m_engine;
    protected WikiContext m_context;
    protected ArrayList<StringTransmutator> m_localLinkMutatorChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_externalLinkMutatorChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_attachmentLinkMutatorChain = new ArrayList();
    protected ArrayList<HeadingListener> m_headingListenerChain = new ArrayList();
    protected ArrayList<StringTransmutator> m_linkMutators = new ArrayList();
    protected boolean m_inlineImages = true;
    protected boolean m_parseAccessRules = true;
    protected List<Pattern> m_inlineImagePatterns = null;
    protected LinkParsingOperations m_linkParsingOperations;
    private static Logger log = Logger.getLogger(MarkupParser.class);
    public static final String PROP_ALLOWHTML = "jspwiki.translatorReader.allowHTML";
    public static final String PROP_RUNPLUGINS = "jspwiki.translatorReader.runPlugins";
    protected static final String LEGACY_CHARS_ALLOWED = "._";
    public static final String PUNCTUATION_CHARS_ALLOWED = " ()&+,-=._$";
    public static final String HASHLINK = "hashlink";
    public static final String OUTLINK_IMAGE = "images/out.png";
    public static final String OUTLINK = "outlink";
    public static final String PROP_USEOUTLINKIMAGE = "jspwiki.translatorReader.useOutlinkImage";
    private static final String INLINE_IMAGE_PATTERNS = "JSPWikiMarkupParser.inlineImagePatterns";
    public static final String PROP_USERELNOFOLLOW = "jspwiki.translatorReader.useRelNofollow";
    public static final String CLASS_WIKIPAGE = "wikipage";
    public static final String CLASS_EDITPAGE = "createpage";
    public static final String CLASS_INTERWIKI = "interwiki";
    public static final String CLASS_FOOTNOTE = "footnote";
    public static final String CLASS_FOOTNOTE_REF = "footnoteref";
    public static final String CLASS_EXTERNAL = "external";
    public static final String CLASS_ATTACHMENT = "attachment";
    public static final String[] CLASS_TYPES = new String[]{"wikipage", "createpage", "", "footnote", "footnoteref", "", "external", "interwiki", "external", "wikipage", "attachment"};

    protected MarkupParser(WikiContext context, Reader in) {
        this.m_engine = context.getEngine();
        this.m_context = context;
        this.m_linkParsingOperations = new LinkParsingOperations(this.m_context);
        this.setInputReader(in);
    }

    public Reader setInputReader(Reader in) {
        PushbackReader old = this.m_in;
        if (in != null) {
            this.m_in = new PushbackReader(new BufferedReader(in), 10240);
        }
        return old;
    }

    public void addLinkTransmutator(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_linkMutators.add(mutator);
        }
    }

    public void addLocalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_localLinkMutatorChain.add(mutator);
        }
    }

    public void addExternalLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_externalLinkMutatorChain.add(mutator);
        }
    }

    public void addAttachmentLinkHook(StringTransmutator mutator) {
        if (mutator != null) {
            this.m_attachmentLinkMutatorChain.add(mutator);
        }
    }

    public void addHeadingListener(HeadingListener listener) {
        if (listener != null) {
            this.m_headingListenerChain.add(listener);
        }
    }

    public void disableAccessRules() {
        this.m_parseAccessRules = false;
    }

    public boolean isParseAccessRules() {
        return this.m_parseAccessRules;
    }

    public void enableImageInlining(boolean toggle) {
        this.m_inlineImages = toggle;
    }

    public boolean isImageInlining() {
        return this.m_inlineImages;
    }

    protected final void initInlineImagePatterns() {
        GlobCompiler compiler = new GlobCompiler();
        ArrayList<Pattern> compiledpatterns = (ArrayList<Pattern>)this.m_engine.getAttribute(INLINE_IMAGE_PATTERNS);
        if (compiledpatterns == null) {
            compiledpatterns = new ArrayList<Pattern>(20);
            Collection<String> ptrns = this.m_engine.getAllInlinedImagePatterns();
            for (String pattern : ptrns) {
                try {
                    compiledpatterns.add(compiler.compile(pattern, 8));
                }
                catch (MalformedPatternException e) {
                    log.error((Object)("Malformed pattern [" + pattern + "] in properties: "), (Throwable)e);
                }
            }
            this.m_engine.setAttribute(INLINE_IMAGE_PATTERNS, compiledpatterns);
        }
        this.m_inlineImagePatterns = Collections.unmodifiableList(compiledpatterns);
    }

    public List<Pattern> getInlineImagePatterns() {
        if (this.m_inlineImagePatterns == null) {
            this.initInlineImagePatterns();
        }
        return this.m_inlineImagePatterns;
    }

    public abstract WikiDocument parse() throws IOException;

    public int getPosition() {
        return this.m_pos;
    }

    protected final int nextToken() throws IOException, NullPointerException {
        ++this.m_pos;
        return this.m_in.read();
    }

    protected void pushBack(int c) throws IOException {
        if (c != -1 && this.m_in != null) {
            --this.m_pos;
            this.m_in.unread(c);
        }
    }

    public static Element makeError(String error) {
        return new Element("span").setAttribute("class", "error").addContent(error);
    }

    public static String cleanLink(String link) {
        return MarkupParser.cleanLink(link, PUNCTUATION_CHARS_ALLOWED);
    }

    public static String cleanLink(String link, String allowedChars) {
        if (link == null) {
            return null;
        }
        link = link.trim();
        StringBuilder clean = new StringBuilder(link.length());
        boolean isWord = true;
        boolean wasSpace = false;
        for (int i = 0; i < link.length(); ++i) {
            char ch = link.charAt(i);
            if (Character.isWhitespace(ch)) {
                if (wasSpace) continue;
                wasSpace = true;
            } else {
                wasSpace = false;
            }
            if (Character.isLetterOrDigit(ch) || allowedChars.indexOf(ch) != -1) {
                if (isWord) {
                    ch = Character.toUpperCase(ch);
                }
                clean.append(ch);
                isWord = false;
                continue;
            }
            isWord = true;
        }
        return clean.toString();
    }

    public static String wikifyLink(String link) {
        return MarkupParser.cleanLink(link, LEGACY_CHARS_ALLOWED);
    }
}

