/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.wiki.WikiContext;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.XHtmlToWikiConfig;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.jdom2.output.XMLOutputter;

public class HtmlStringToWikiTranslator {
    private static final String CYBERNEKO_PARSER = "org.cyberneko.html.parsers.SAXParser";

    public String translate(String html) throws JDOMException, IOException {
        return this.translate(html, new XHtmlToWikiConfig());
    }

    public String translate(String html, WikiContext wikiContext) throws JDOMException, IOException {
        return this.translate(html, new XHtmlToWikiConfig(wikiContext));
    }

    public String translate(String html, XHtmlToWikiConfig config) throws JDOMException, IOException {
        Element element = this.htmlStringToElement(html);
        XHtmlElementToWikiTranslator xhtmlTranslator = new XHtmlElementToWikiTranslator(element, config);
        String wikiMarkup = xhtmlTranslator.getWikiString();
        return wikiMarkup;
    }

    private Element htmlStringToElement(String html) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)new XMLReaderSAX2Factory(true, CYBERNEKO_PARSER), null, null);
        Document doc = builder.build((Reader)new StringReader(html));
        Element element = doc.getRootElement();
        return element;
    }

    public static String element2String(Element element) {
        Document document = new Document(element);
        XMLOutputter outputter = new XMLOutputter();
        return outputter.outputString(document);
    }
}

