/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.forms;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.wiki.WikiContext;
import org.apache.wiki.api.exceptions.PluginException;
import org.apache.wiki.forms.FormElement;
import org.apache.wiki.forms.FormInfo;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.util.XHTML;
import org.apache.wiki.util.XhtmlUtil;
import org.jdom2.Element;

public class FormTextarea
extends FormElement {
    public static final String PARAM_ROWS = "rows";
    public static final String PARAM_COLS = "cols";

    @Override
    public String execute(WikiContext ctx, Map<String, String> params) throws PluginException {
        FormInfo info = this.getFormInfo(ctx);
        Map<String, String> previousValues = null;
        ResourceBundle rb = Preferences.getBundle(ctx, "plugin.PluginResources");
        if (info != null) {
            if (info.hide()) {
                return "<p>" + rb.getString("formclose.noneedtoshow") + "</p>";
            }
            previousValues = info.getSubmission();
        }
        if (previousValues == null) {
            previousValues = new HashMap<String, String>();
        }
        Element field = this.buildTextArea(params, previousValues, rb);
        return XhtmlUtil.serialize(field, XhtmlUtil.EXPAND_EMPTY_NODES);
    }

    private Element buildTextArea(Map<String, String> params, Map<String, String> previousValues, ResourceBundle rb) throws PluginException {
        String inputName = params.get("name");
        String rows = params.get(PARAM_ROWS);
        String cols = params.get(PARAM_COLS);
        if (inputName == null) {
            throw new PluginException(rb.getString("formtextarea.namemissing"));
        }
        Element field = XhtmlUtil.element(XHTML.textarea);
        field.setAttribute("name", "nbf_" + inputName);
        if (rows != null) {
            field.setAttribute(PARAM_ROWS, rows);
        }
        if (cols != null) {
            field.setAttribute(PARAM_COLS, cols);
        }
        if (previousValues != null) {
            String oldValue = previousValues.get(inputName);
            if (oldValue != null) {
                field.addContent(oldValue);
            } else {
                oldValue = params.get("value");
                if (oldValue != null) {
                    field.addContent(oldValue);
                }
            }
        }
        return field;
    }
}

