/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.content;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageRenameEvent;
import org.apache.wiki.parser.MarkupParser;
import org.apache.wiki.util.TextUtil;

public class PageRenamer {
    private static final Logger log = Logger.getLogger(PageRenamer.class);
    private boolean m_camelCase = false;

    public String renamePage(WikiContext context, String renameFrom, String renameTo, boolean changeReferrers) throws WikiException {
        if (renameFrom == null || renameFrom.length() == 0) {
            throw new WikiException("From name may not be null or empty");
        }
        if (renameTo == null || renameTo.length() == 0) {
            throw new WikiException("To name may not be null or empty");
        }
        String renameToClean = MarkupParser.cleanLink(renameTo.trim());
        if (renameToClean.equals(renameFrom)) {
            throw new WikiException("You cannot rename the page to itself");
        }
        WikiEngine engine = context.getEngine();
        WikiPage fromPage = engine.getPage(renameFrom);
        if (fromPage == null) {
            throw new WikiException("No such page " + renameFrom);
        }
        WikiPage toPage = engine.getPage(renameToClean);
        if (toPage != null) {
            throw new WikiException("Page already exists " + renameToClean);
        }
        this.m_camelCase = TextUtil.getBooleanProperty(engine.getWikiProperties(), "jspwiki.translatorReader.camelCaseLinks", this.m_camelCase);
        Set<String> referrers = this.getReferencesToChange(fromPage, engine);
        Collection attachmentsOldName = engine.getAttachmentManager().listAttachments(fromPage);
        for (Attachment att : attachmentsOldName) {
            WikiPage fromAttPage = engine.getPage(att.getName());
            engine.getReferenceManager().pageRemoved(fromAttPage);
        }
        engine.getPageManager().getProvider().movePage(renameFrom, renameToClean);
        if (engine.getAttachmentManager().attachmentsEnabled()) {
            engine.getAttachmentManager().getCurrentProvider().moveAttachmentsForPage(renameFrom, renameToClean);
        }
        if ((toPage = engine.getPage(renameToClean)) == null) {
            throw new InternalWikiException("Rename seems to have failed for some strange reason - please check logs!");
        }
        toPage.setAttribute("changenote", fromPage.getName() + " ==> " + toPage.getName());
        toPage.setAuthor(context.getCurrentUser().getName());
        engine.getPageManager().putPageText(toPage, engine.getPureText(toPage));
        engine.getReferenceManager().pageRemoved(fromPage);
        engine.updateReferences(toPage);
        if (changeReferrers) {
            this.updateReferrers(context, fromPage, toPage, referrers);
        }
        engine.getSearchManager().reindexPage(toPage);
        Collection attachmentsNewName = engine.getAttachmentManager().listAttachments(toPage);
        for (Attachment att : attachmentsNewName) {
            WikiPage toAttPage = engine.getPage(att.getName());
            engine.updateReferences(toAttPage);
            engine.getSearchManager().reindexPage(att);
        }
        WikiEventManager.fireEvent(this, new WikiPageRenameEvent((Object)this, renameFrom, renameToClean));
        return renameToClean;
    }

    private void updateReferrers(WikiContext context, WikiPage fromPage, WikiPage toPage, Set<String> referrers) {
        WikiEngine engine = context.getEngine();
        if (referrers.isEmpty()) {
            return;
        }
        for (String pageName : referrers) {
            if (pageName.equals(fromPage.getName())) {
                pageName = toPage.getName();
            }
            WikiPage p = engine.getPage(pageName);
            String sourceText = engine.getPureText(p);
            String newText = this.replaceReferrerString(context, sourceText, fromPage.getName(), toPage.getName());
            if (this.m_camelCase) {
                newText = this.replaceCCReferrerString(context, newText, fromPage.getName(), toPage.getName());
            }
            if (sourceText.equals(newText)) continue;
            p.setAttribute("changenote", fromPage.getName() + " ==> " + toPage.getName());
            p.setAuthor(context.getCurrentUser().getName());
            try {
                engine.getPageManager().putPageText(p, newText);
                engine.updateReferences(p);
            }
            catch (ProviderException e) {
                log.error((Object)"Unable to perform rename.", (Throwable)e);
            }
        }
    }

    private Set<String> getReferencesToChange(WikiPage fromPage, WikiEngine engine) {
        TreeSet<String> referrers = new TreeSet<String>();
        Collection r = engine.getReferenceManager().findReferrers(fromPage.getName());
        if (r != null) {
            referrers.addAll(r);
        }
        try {
            Collection attachments = engine.getAttachmentManager().listAttachments(fromPage);
            for (Attachment att : attachments) {
                Collection c = engine.getReferenceManager().findReferrers(att.getName());
                if (c == null) continue;
                referrers.addAll(c);
            }
        }
        catch (ProviderException e) {
            log.error((Object)"Provider error while fetching attachments for rename", (Throwable)e);
        }
        return referrers;
    }

    private String replaceCCReferrerString(WikiContext context, String sourceText, String from, String to) {
        StringBuilder sb = new StringBuilder(sourceText.length() + 32);
        Pattern linkPattern = Pattern.compile("\\p{Lu}+\\p{Ll}+\\p{Lu}+[\\p{L}\\p{Digit}]*");
        Matcher matcher = linkPattern.matcher(sourceText);
        int start = 0;
        while (matcher.find(start)) {
            String match = matcher.group();
            sb.append(sourceText.substring(start, matcher.start()));
            int lastOpenBrace = sourceText.lastIndexOf(91, matcher.start());
            int lastCloseBrace = sourceText.lastIndexOf(93, matcher.start());
            if (match.equals(from) && lastCloseBrace >= lastOpenBrace) {
                sb.append(to);
            } else {
                sb.append(match);
            }
            start = matcher.end();
        }
        sb.append(sourceText.substring(start));
        return sb.toString();
    }

    private String replaceReferrerString(WikiContext context, String sourceText, String from, String to) {
        StringBuilder sb = new StringBuilder(sourceText.length() + 32);
        Pattern linkPattern = Pattern.compile("([\\[\\~]?)\\[([^\\|\\]]*)(\\|)?([^\\|\\]]*)(\\|)?([^\\|\\]]*)\\]");
        Matcher matcher = linkPattern.matcher(sourceText);
        int start = 0;
        while (matcher.find(start)) {
            int charBefore = 65535;
            if (matcher.start() > 0) {
                charBefore = sourceText.charAt(matcher.start() - 1);
            }
            if (matcher.group(1).length() > 0 || charBefore == 126 || charBefore == 91) {
                sb.append(sourceText.substring(start, matcher.end()));
                start = matcher.end();
                continue;
            }
            String text = matcher.group(2);
            String link = matcher.group(4);
            String attr = matcher.group(6);
            if (link.length() == 0) {
                text = this.replaceSingleLink(context, text, from, to);
            } else {
                link = this.replaceSingleLink(context, link, from, to);
                text = TextUtil.replaceString(text, from, to);
            }
            sb.append(sourceText.substring(start, matcher.start()));
            sb.append("[" + text);
            if (link.length() > 0) {
                sb.append("|" + link);
            }
            if (attr.length() > 0) {
                sb.append("|" + attr);
            }
            sb.append("]");
            start = matcher.end();
        }
        sb.append(sourceText.substring(start));
        return sb.toString();
    }

    private String replaceSingleLink(WikiContext context, String original, String from, String newlink) {
        int hash = original.indexOf(35);
        int slash = original.indexOf(47);
        String reallink = original;
        if (hash != -1) {
            reallink = original.substring(0, hash);
        }
        if (slash != -1) {
            reallink = original.substring(0, slash);
        }
        reallink = MarkupParser.cleanLink(reallink);
        String oldStyleRealLink = MarkupParser.wikifyLink(reallink);
        if (reallink.equals(from) || original.equals(from) || oldStyleRealLink.equals(from)) {
            int blank = reallink.indexOf(" ");
            if (blank != -1) {
                return original + "|" + newlink;
            }
            return newlink + (hash > 0 ? original.substring(hash) : "") + (slash > 0 ? original.substring(slash) : "");
        }
        return original;
    }
}

