/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.attachment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.RedirectException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.attachment.Attachment;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.auth.AuthorizationManager;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.auth.permissions.PermissionFactory;
import org.apache.wiki.preferences.Preferences;
import org.apache.wiki.ui.progress.ProgressItem;
import org.apache.wiki.util.HttpUtil;
import org.apache.wiki.util.TextUtil;

public class AttachmentServlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 8192;
    private static final long serialVersionUID = 3257282552187531320L;
    private WikiEngine m_engine;
    private static final Logger log = Logger.getLogger(AttachmentServlet.class);
    private static final String HDR_VERSION = "version";
    protected static final long DEFAULT_EXPIRY = 86400000L;
    private int m_maxSize = Integer.MAX_VALUE;
    private String[] m_allowedPatterns;
    private String[] m_forbiddenPatterns;

    public void init(ServletConfig config) throws ServletException {
        this.m_engine = WikiEngine.getInstance(config);
        Properties props = this.m_engine.getWikiProperties();
        String tmpDir = this.m_engine.getWorkDir() + File.separator + "attach-tmp";
        this.m_maxSize = TextUtil.getIntegerProperty(props, "jspwiki.attachment.maxsize", Integer.MAX_VALUE);
        String allowed = TextUtil.getStringProperty(props, "jspwiki.attachment.allowed", null);
        this.m_allowedPatterns = allowed != null && allowed.length() > 0 ? allowed.toLowerCase().split("\\s") : new String[0];
        String forbidden = TextUtil.getStringProperty(props, "jspwiki.attachment.forbidden", null);
        this.m_forbiddenPatterns = forbidden != null && forbidden.length() > 0 ? forbidden.toLowerCase().split("\\s") : new String[0];
        File f = new File(tmpDir);
        if (!f.exists()) {
            f.mkdirs();
        } else if (!f.isDirectory()) {
            log.fatal((Object)("A file already exists where the temporary dir is supposed to be: " + tmpDir + ".  Please remove it."));
        }
        log.debug((Object)("UploadServlet initialized. Using " + tmpDir + " for temporary storage."));
    }

    private boolean isTypeAllowed(String name) {
        int i;
        if (name == null || name.length() == 0) {
            return false;
        }
        name = name.toLowerCase();
        for (i = 0; i < this.m_forbiddenPatterns.length; ++i) {
            if (!name.endsWith(this.m_forbiddenPatterns[i]) || this.m_forbiddenPatterns[i].length() <= 0) continue;
            return false;
        }
        for (i = 0; i < this.m_allowedPatterns.length; ++i) {
            if (!name.endsWith(this.m_allowedPatterns[i]) || this.m_allowedPatterns[i].length() <= 0) continue;
            return true;
        }
        return this.m_allowedPatterns.length == 0;
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) {
        res.setHeader("Allow", "GET, PUT, POST, OPTIONS, PROPFIND, PROPPATCH, MOVE, COPY, DELETE");
        res.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        WikiContext context = this.m_engine.createContext(req, WikiContext.ATTACH);
        String version = req.getParameter(HDR_VERSION);
        String nextPage = req.getParameter("nextpage");
        String msg = "An error occurred. Ouch.";
        int ver = -1;
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        AuthorizationManager authmgr = this.m_engine.getAuthorizationManager();
        String page = context.getPage().getName();
        if (page == null) {
            log.info((Object)"Invalid attachment name.");
            res.sendError(400);
            return;
        }
        ServletOutputStream out = null;
        InputStream in = null;
        try {
            Attachment att;
            log.debug((Object)("Attempting to download att " + page + ", version " + version));
            if (version != null) {
                ver = Integer.parseInt(version);
            }
            if ((att = mgr.getAttachmentInfo(page, ver)) != null) {
                PagePermission permission = PermissionFactory.getPagePermission(att, "view");
                if (!authmgr.checkPermission(context.getWikiSession(), permission)) {
                    log.debug((Object)"User does not have permission for this");
                    res.sendError(403);
                    return;
                }
                if (HttpUtil.checkFor304(req, att.getName(), att.getLastModified())) {
                    log.debug((Object)"Client has latest version already, sending 304...");
                    res.sendError(304);
                    return;
                }
                String mimetype = AttachmentServlet.getMimeType(context, att.getFileName());
                res.setContentType(mimetype);
                res.addHeader("Content-Disposition", "inline; filename=\"" + att.getFileName() + "\";");
                res.addDateHeader("Last-Modified", att.getLastModified().getTime());
                if (!att.isCacheable()) {
                    res.addHeader("Pragma", "no-cache");
                    res.addHeader("Cache-control", "no-cache");
                }
                if (att.getSize() >= 0L) {
                    res.setContentLength((int)att.getSize());
                }
                out = res.getOutputStream();
                in = mgr.getAttachmentStream(context, att);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = in.read(buffer)) > -1) {
                    out.write(buffer, 0, read);
                }
                if (log.isDebugEnabled()) {
                    msg = "Attachment " + att.getFileName() + " sent to " + req.getRemoteUser() + " on " + HttpUtil.getRemoteAddress(req);
                    log.debug((Object)msg);
                }
                if (nextPage != null) {
                    res.sendRedirect(this.validateNextPage(nextPage, this.m_engine.getURL(WikiContext.ERROR, "", null, false)));
                }
            } else {
                msg = "Attachment '" + page + "', version " + ver + " does not exist.";
                log.info((Object)msg);
                res.sendError(404, msg);
            }
        }
        catch (ProviderException pe) {
            msg = "Provider error: " + pe.getMessage();
            log.debug((Object)"Provider failed while reading", (Throwable)pe);
            try {
                res.sendError(500, msg);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)("Invalid version number: " + version));
            res.sendError(400, "Invalid version number");
        }
        catch (SocketException se) {
            log.debug((Object)"I/O exception during download", (Throwable)se);
        }
        catch (IOException ioe) {
            msg = "Error: " + ioe.getMessage();
            log.debug((Object)"I/O exception during download", (Throwable)ioe);
            try {
                res.sendError(500, msg);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
    }

    private static String getMimeType(WikiContext ctx, String fileName) {
        ServletContext s;
        String mimetype = null;
        HttpServletRequest req = ctx.getHttpRequest();
        if (req != null && (s = req.getSession().getServletContext()) != null) {
            mimetype = s.getMimeType(fileName.toLowerCase());
        }
        if (mimetype == null) {
            mimetype = "application/binary";
        }
        return mimetype;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            String nextPage = this.upload(req);
            req.getSession().removeAttribute("msg");
            res.sendRedirect(nextPage);
        }
        catch (RedirectException e) {
            WikiSession session = WikiSession.getWikiSession(this.m_engine, req);
            session.addMessage(e.getMessage());
            req.getSession().setAttribute("msg", (Object)e.getMessage());
            res.sendRedirect(e.getRedirect());
        }
    }

    private String validateNextPage(String nextPage, String errorPage) {
        if (nextPage.indexOf("://") != -1 && !nextPage.startsWith(this.m_engine.getBaseURL())) {
            log.warn((Object)("Detected phishing attempt by redirecting to an unsecure location: " + nextPage));
            nextPage = errorPage;
        }
        return nextPage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String upload(HttpServletRequest req) throws RedirectException, IOException {
        String errorPage;
        String msg = "";
        String attName = "(unknown)";
        String nextPage = errorPage = this.m_engine.getURL(WikiContext.ERROR, "", null, false);
        String progressId = req.getParameter("progressid");
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            throw new RedirectException("Not a file upload", errorPage);
        }
        try {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            WikiContext context = this.m_engine.createContext(req, WikiContext.ATTACH);
            UploadListener pl = new UploadListener();
            this.m_engine.getProgressManager().startProgress(pl, progressId);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setHeaderEncoding("UTF-8");
            if (!context.hasAdminPermissions()) {
                upload.setFileSizeMax((long)this.m_maxSize);
            }
            upload.setProgressListener((ProgressListener)pl);
            List items = upload.parseRequest(req);
            String wikipage = null;
            String changeNote = null;
            ArrayList<FileItem> fileItems = new ArrayList<FileItem>();
            for (FileItem item : items) {
                if (item.isFormField()) {
                    if (item.getFieldName().equals("page")) {
                        wikipage = item.getString("UTF-8");
                        int x = wikipage.indexOf("/");
                        if (x == -1) continue;
                        wikipage = wikipage.substring(0, x);
                        continue;
                    }
                    if (item.getFieldName().equals("changenote")) {
                        changeNote = item.getString("UTF-8");
                        if (changeNote == null) continue;
                        changeNote = TextUtil.replaceEntities(changeNote);
                        continue;
                    }
                    if (!item.getFieldName().equals("nextpage")) continue;
                    nextPage = this.validateNextPage(item.getString("UTF-8"), errorPage);
                    continue;
                }
                fileItems.add(item);
            }
            if (fileItems.size() == 0) {
                throw new RedirectException("Broken file upload", errorPage);
            }
            for (FileItem actualFile : fileItems) {
                String filename = actualFile.getName();
                long fileSize = actualFile.getSize();
                InputStream in = actualFile.getInputStream();
                try {
                    this.executeUpload(context, in, filename, nextPage, wikipage, changeNote, fileSize);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)in);
                }
            }
        }
        catch (ProviderException e) {
            msg = "Upload failed because the provider failed: " + e.getMessage();
            log.warn((Object)(msg + " (attachment: " + attName + ")"), (Throwable)e);
            throw new IOException(msg);
        }
        catch (IOException e) {
            msg = "Upload failure: " + e.getMessage();
            log.warn((Object)(msg + " (attachment: " + attName + ")"), (Throwable)e);
            throw e;
        }
        catch (FileUploadException e) {
            msg = "Upload failure: " + e.getMessage();
            log.warn((Object)(msg + " (attachment: " + attName + ")"), (Throwable)e);
            throw new IOException(msg, e);
        }
        finally {
            this.m_engine.getProgressManager().stopProgress(progressId);
        }
        return nextPage;
    }

    protected boolean executeUpload(WikiContext context, InputStream data, String filename, String errorPage, String parentPage, String changenote, long contentLength) throws RedirectException, IOException, ProviderException {
        boolean created = false;
        try {
            filename = AttachmentManager.validateFileName(filename);
        }
        catch (WikiException e) {
            throw new RedirectException(Preferences.getBundle(context, "CoreResources").getString(e.getMessage()), errorPage);
        }
        if (!context.hasAdminPermissions()) {
            if (contentLength > (long)this.m_maxSize) {
                throw new RedirectException("File exceeds maximum size (" + this.m_maxSize + " bytes)", errorPage);
            }
            if (!this.isTypeAllowed(filename)) {
                throw new RedirectException("Files of this type may not be uploaded to this wiki", errorPage);
            }
        }
        Principal user = context.getCurrentUser();
        AttachmentManager mgr = this.m_engine.getAttachmentManager();
        log.debug((Object)("file=" + filename));
        if (data == null) {
            log.error((Object)"File could not be opened.");
            throw new RedirectException("File could not be opened.", errorPage);
        }
        Attachment att = mgr.getAttachmentInfo(context.getPage().getName());
        if (att == null) {
            att = new Attachment(this.m_engine, parentPage, filename);
            created = true;
        }
        att.setSize(contentLength);
        PagePermission permission = PermissionFactory.getPagePermission(att, "upload");
        if (this.m_engine.getAuthorizationManager().checkPermission(context.getWikiSession(), permission)) {
            if (user != null) {
                att.setAuthor(user.getName());
            }
            if (changenote != null && changenote.length() > 0) {
                att.setAttribute("changenote", changenote);
            }
            try {
                this.m_engine.getAttachmentManager().storeAttachment(att, data);
            }
            catch (ProviderException pe) {
                throw new ProviderException(Preferences.getBundle(context, "CoreResources").getString(pe.getMessage()));
            }
        } else {
            throw new RedirectException("No permission to upload a file", errorPage);
        }
        log.info((Object)("User " + user + " uploaded attachment to " + parentPage + " called " + filename + ", size " + att.getSize()));
        return created;
    }

    private static class UploadListener
    extends ProgressItem
    implements ProgressListener {
        public long m_currentBytes;
        public long m_totalBytes;

        private UploadListener() {
        }

        public void update(long recvdBytes, long totalBytes, int item) {
            this.m_currentBytes = recvdBytes;
            this.m_totalBytes = totalBytes;
        }

        @Override
        public int getProgress() {
            return (int)((double)((float)this.m_currentBytes / (float)this.m_totalBytes * 100.0f) + 0.5);
        }
    }
}

