/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.ajax;

import java.io.IOException;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiSession;
import org.apache.wiki.ajax.AjaxUtil;
import org.apache.wiki.ajax.WikiAjaxServlet;
import org.apache.wiki.auth.permissions.PagePermission;
import org.apache.wiki.util.TextUtil;

public class WikiAjaxDispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Map<String, AjaxServletContainer> ajaxServlets = new HashMap<String, AjaxServletContainer>();
    static final Logger log = Logger.getLogger((String)WikiAjaxDispatcherServlet.class.getName());
    private String PATH_AJAX = "/ajax/";
    private WikiEngine m_engine;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_engine = WikiEngine.getInstance(config);
        this.PATH_AJAX = "/" + TextUtil.getStringProperty(this.m_engine.getWikiProperties(), "jspwiki.ajax.url.prefix", "ajax") + "/";
        log.info((Object)"WikiAjaxDispatcherServlet initialized.");
    }

    public static void registerServlet(WikiAjaxServlet servlet) {
        WikiAjaxDispatcherServlet.registerServlet(servlet.getServletMapping(), servlet);
    }

    public static void registerServlet(String alias, WikiAjaxServlet servlet) {
        WikiAjaxDispatcherServlet.registerServlet(alias, servlet, PagePermission.VIEW);
    }

    public static void registerServlet(String alias, WikiAjaxServlet servlet, Permission perm) {
        log.info((Object)("WikiAjaxDispatcherServlet registering " + alias + "=" + servlet + " perm=" + perm));
        ajaxServlets.put(alias, new AjaxServletContainer(alias, servlet, perm));
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.performAction(req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.performAction(req, res);
    }

    private void performAction(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String path = req.getRequestURI();
        String servletName = this.getServletName(path);
        if (servletName != null) {
            AjaxServletContainer container = this.findServletContainer(servletName);
            if (container != null) {
                WikiAjaxServlet servlet = container.servlet;
                if (this.validatePermission(req, container)) {
                    String paramString;
                    req.setCharacterEncoding(this.m_engine.getContentEncoding());
                    res.setCharacterEncoding(this.m_engine.getContentEncoding());
                    String actionName = AjaxUtil.getNextPathPart(req.getRequestURI(), servlet.getServletMapping());
                    log.debug((Object)("actionName=" + actionName));
                    String params = req.getParameter("params");
                    log.debug((Object)("params=" + params));
                    List<String> paramValues = new ArrayList<String>();
                    if (params instanceof String && StringUtils.isNotBlank((String)(paramString = params))) {
                        paramValues = Arrays.asList(paramString.trim().split(","));
                    }
                    servlet.service(req, res, actionName, paramValues);
                } else {
                    log.warn((Object)("Servlet container " + container + " not authorised. Permission required."));
                }
            } else {
                log.error((Object)("No registered class for servletName=" + servletName + " in path=" + path));
                throw new ServletException("No registered class for servletName=" + servletName);
            }
        }
    }

    private boolean validatePermission(HttpServletRequest req, AjaxServletContainer container) {
        WikiEngine e = WikiEngine.getInstance(req.getSession().getServletContext(), null);
        boolean valid = false;
        if (container != null) {
            valid = e.getAuthorizationManager().checkPermission(WikiSession.getWikiSession(e, req), container.permission);
        }
        return valid;
    }

    public String getServletName(String path) throws ServletException {
        return AjaxUtil.getNextPathPart(path, this.PATH_AJAX);
    }

    private AjaxServletContainer findServletContainer(String servletAlias) {
        return ajaxServlets.get(servletAlias);
    }

    public WikiAjaxServlet findServletByName(String servletAlias) {
        AjaxServletContainer container = ajaxServlets.get(servletAlias);
        if (container != null) {
            return container.servlet;
        }
        return null;
    }

    private static class AjaxServletContainer {
        String alias;
        WikiAjaxServlet servlet;
        Permission permission;

        public AjaxServletContainer(String alias, WikiAjaxServlet servlet, Permission permission) {
            this.alias = alias;
            this.servlet = servlet;
            this.permission = permission;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " " + this.alias + "=" + this.servlet.getClass().getSimpleName() + " permission=" + this.permission;
        }
    }
}

