/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.acl.AclImpl;

public class WikiPage
implements Cloneable,
Comparable {
    private static final long serialVersionUID = 1L;
    private String m_name;
    private WikiEngine m_engine;
    private String m_wiki;
    private Date m_lastModified;
    private long m_fileSize = -1L;
    private int m_version = -1;
    private String m_author = null;
    private final HashMap<String, Object> m_attributes = new HashMap();
    public static final String DESCRIPTION = "summary";
    public static final String ALIAS = "alias";
    public static final String REDIRECT = "redirect";
    public static final String AUTHOR = "author";
    public static final String CHANGENOTE = "changenote";
    public static final String VIEWCOUNT = "viewcount";
    private Acl m_accessList = null;
    private boolean m_hasMetadata = false;

    public WikiPage(WikiEngine engine, String name) {
        this.m_engine = engine;
        this.m_name = name;
        this.m_wiki = engine.getApplicationName();
    }

    public String getName() {
        return this.m_name;
    }

    public Object getAttribute(String key) {
        return this.m_attributes.get(key);
    }

    public void setAttribute(String key, Object attribute) {
        this.m_attributes.put(key, attribute);
    }

    public Map getAttributes() {
        return this.m_attributes;
    }

    public Object removeAttribute(String key) {
        return this.m_attributes.remove(key);
    }

    public Date getLastModified() {
        return this.m_lastModified;
    }

    public void setLastModified(Date date) {
        this.m_lastModified = date;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public int getVersion() {
        return this.m_version;
    }

    public long getSize() {
        return this.m_fileSize;
    }

    public void setSize(long size) {
        this.m_fileSize = size;
    }

    public Acl getAcl() {
        return this.m_accessList;
    }

    public void setAcl(Acl acl) {
        this.m_accessList = acl;
    }

    public void setAuthor(String author) {
        this.m_author = author;
    }

    public String getAuthor() {
        return this.m_author;
    }

    public String getWiki() {
        return this.m_wiki;
    }

    public void invalidateMetadata() {
        this.m_hasMetadata = false;
        this.setAcl(null);
        this.m_attributes.clear();
    }

    public boolean hasMetadata() {
        return this.m_hasMetadata;
    }

    public void setHasMetadata() {
        this.m_hasMetadata = true;
    }

    public String toString() {
        return "WikiPage [" + this.m_wiki + ":" + this.m_name + ",ver=" + this.m_version + ",mod=" + this.m_lastModified + "]";
    }

    public Object clone() {
        WikiPage p = new WikiPage(this.m_engine, this.m_name);
        p.m_wiki = this.m_wiki;
        p.m_author = this.m_author;
        p.m_version = this.m_version;
        p.m_lastModified = this.m_lastModified != null ? (Date)this.m_lastModified.clone() : null;
        p.m_fileSize = this.m_fileSize;
        for (Map.Entry<String, Object> entry : this.m_attributes.entrySet()) {
            p.m_attributes.put(entry.getKey(), entry.getValue());
        }
        if (this.m_accessList != null) {
            p.m_accessList = new AclImpl();
            Enumeration<AclEntry> entries = this.m_accessList.entries();
            while (entries.hasMoreElements()) {
                AclEntry e = entries.nextElement();
                p.m_accessList.addEntry(e);
            }
        }
        return p;
    }

    public int compareTo(Object page) {
        return this.m_engine.getPageSorter().compare(this, (WikiPage)page);
    }

    public int hashCode() {
        return this.m_name.hashCode() * this.m_version;
    }
}

