/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.IOException;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.apache.wiki.PageLock;
import org.apache.wiki.WikiBackgroundThread;
import org.apache.wiki.WikiContext;
import org.apache.wiki.WikiEngine;
import org.apache.wiki.WikiPage;
import org.apache.wiki.api.exceptions.NoRequiredPropertyException;
import org.apache.wiki.api.exceptions.ProviderException;
import org.apache.wiki.api.exceptions.WikiException;
import org.apache.wiki.auth.WikiPrincipal;
import org.apache.wiki.auth.WikiSecurityException;
import org.apache.wiki.auth.acl.Acl;
import org.apache.wiki.auth.acl.AclEntry;
import org.apache.wiki.auth.acl.AclEntryImpl;
import org.apache.wiki.auth.user.UserProfile;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;
import org.apache.wiki.event.WikiEventManager;
import org.apache.wiki.event.WikiPageEvent;
import org.apache.wiki.event.WikiSecurityEvent;
import org.apache.wiki.modules.ModuleManager;
import org.apache.wiki.modules.WikiModuleInfo;
import org.apache.wiki.providers.RepositoryModifiedException;
import org.apache.wiki.providers.WikiPageProvider;
import org.apache.wiki.util.ClassUtil;
import org.apache.wiki.util.TextUtil;
import org.apache.wiki.workflow.Outcome;
import org.apache.wiki.workflow.Task;
import org.apache.wiki.workflow.Workflow;

public class PageManager
extends ModuleManager
implements WikiEventListener {
    private static final long serialVersionUID = 1L;
    public static final String PROP_PAGEPROVIDER = "jspwiki.pageProvider";
    public static final String PROP_USECACHE = "jspwiki.usePageCache";
    public static final String PROP_LOCKEXPIRY = "jspwiki.lockExpiryTime";
    public static final String PRESAVE_TASK_MESSAGE_KEY = "task.preSaveWikiPage";
    public static final String PRESAVE_WIKI_CONTEXT = "wikiContext";
    public static final String SAVE_APPROVER = "workflow.saveWikiPage";
    public static final String SAVE_DECISION_MESSAGE_KEY = "decision.saveWikiPage";
    public static final String SAVE_REJECT_MESSAGE_KEY = "notification.saveWikiPage.reject";
    public static final String SAVE_TASK_MESSAGE_KEY = "task.saveWikiPage";
    public static final String FACT_PAGE_NAME = "fact.pageName";
    public static final String FACT_DIFF_TEXT = "fact.diffText";
    public static final String FACT_CURRENT_TEXT = "fact.currentText";
    public static final String FACT_PROPOSED_TEXT = "fact.proposedText";
    public static final String FACT_IS_AUTHENTICATED = "fact.isAuthenticated";
    static Logger log = Logger.getLogger(PageManager.class);
    private WikiPageProvider m_provider;
    protected ConcurrentHashMap<String, PageLock> m_pageLocks = new ConcurrentHashMap();
    private WikiEngine m_engine;
    private int m_expiryTime = 60;
    private LockReaper m_reaper = null;

    public PageManager(WikiEngine engine, Properties props) throws WikiException {
        super(engine);
        this.m_engine = engine;
        boolean useCache = "true".equals(props.getProperty(PROP_USECACHE));
        this.m_expiryTime = TextUtil.parseIntParameter(props.getProperty(PROP_LOCKEXPIRY), 60);
        String classname = useCache ? "org.apache.wiki.providers.CachingProvider" : TextUtil.getRequiredProperty(props, PROP_PAGEPROVIDER);
        try {
            log.debug((Object)("Page provider class: '" + classname + "'"));
            Class<?> providerclass = ClassUtil.findClass("org.apache.wiki.providers", classname);
            this.m_provider = (WikiPageProvider)providerclass.newInstance();
            log.debug((Object)("Initializing page provider class " + this.m_provider));
            this.m_provider.initialize(this.m_engine, props);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Unable to locate provider class '" + classname + "' (" + e.getMessage() + ")"), (Throwable)e);
            throw new WikiException("No provider class. (" + e.getMessage() + ")", e);
        }
        catch (InstantiationException e) {
            log.error((Object)("Unable to create provider class '" + classname + "' (" + e.getMessage() + ")"), (Throwable)e);
            throw new WikiException("Faulty provider class. (" + e.getMessage() + ")", e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)("Illegal access to provider class '" + classname + "' (" + e.getMessage() + ")"), (Throwable)e);
            throw new WikiException("Illegal provider class. (" + e.getMessage() + ")", e);
        }
        catch (NoRequiredPropertyException e) {
            log.error((Object)("Provider did not found a property it was looking for: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)("An I/O exception occurred while trying to create a new page provider: " + classname), (Throwable)e);
            throw new WikiException("Unable to start page provider: " + e.getMessage(), e);
        }
    }

    public WikiPageProvider getProvider() {
        return this.m_provider;
    }

    public Collection getAllPages() throws ProviderException {
        return this.m_provider.getAllPages();
    }

    public String getPageText(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        String text = null;
        try {
            text = this.m_provider.getPageText(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            log.info((Object)("Repository has been modified externally while fetching page " + pageName));
            WikiPage p = this.m_provider.getPageInfo(pageName, version);
            this.m_engine.updateReferences(p);
            if (p != null) {
                this.m_engine.getSearchManager().reindexPage(p);
                text = this.m_provider.getPageText(pageName, version);
            }
            WikiPage dummy = new WikiPage(this.m_engine, pageName);
            this.m_engine.getSearchManager().pageRemoved(dummy);
            this.m_engine.getReferenceManager().pageRemoved(dummy);
        }
        return text;
    }

    public WikiEngine getEngine() {
        return this.m_engine;
    }

    public void putPageText(WikiPage page, String content) throws ProviderException {
        if (page == null || page.getName() == null || page.getName().length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        this.m_provider.putPageText(page, content);
    }

    public PageLock lockPage(WikiPage page, String user) {
        PageLock lock = null;
        if (this.m_reaper == null) {
            this.m_reaper = new LockReaper(this.m_engine);
            this.m_reaper.start();
        }
        this.fireEvent(10, page.getName());
        lock = this.m_pageLocks.get(page.getName());
        if (lock == null) {
            Date d = new Date();
            lock = new PageLock(page, user, d, new Date(d.getTime() + (long)(this.m_expiryTime * 60) * 1000L));
            this.m_pageLocks.put(page.getName(), lock);
            log.debug((Object)("Locked page " + page.getName() + " for " + user));
        } else {
            log.debug((Object)("Page " + page.getName() + " already locked by " + lock.getLocker()));
            lock = null;
        }
        return lock;
    }

    public void unlockPage(PageLock lock) {
        if (lock == null) {
            return;
        }
        this.m_pageLocks.remove(lock.getPage());
        log.debug((Object)("Unlocked page " + lock.getPage()));
        this.fireEvent(11, lock.getPage());
    }

    public PageLock getCurrentLock(WikiPage page) {
        return this.m_pageLocks.get(page.getName());
    }

    public List<PageLock> getActiveLocks() {
        ArrayList<PageLock> result = new ArrayList<PageLock>();
        for (PageLock lock : this.m_pageLocks.values()) {
            result.add(lock);
        }
        return result;
    }

    public WikiPage getPageInfo(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name '" + pageName + "'");
        }
        WikiPage page = null;
        try {
            page = this.m_provider.getPageInfo(pageName, version);
        }
        catch (RepositoryModifiedException e) {
            log.info((Object)("Repository has been modified externally while fetching info for " + pageName));
            page = this.m_provider.getPageInfo(pageName, version);
            if (page != null) {
                this.m_engine.updateReferences(page);
            }
            this.m_engine.getReferenceManager().pageRemoved(new WikiPage(this.m_engine, pageName));
        }
        return page;
    }

    public List getVersionHistory(String pageName) throws ProviderException {
        if (this.pageExists(pageName)) {
            return this.m_provider.getVersionHistory(pageName);
        }
        return null;
    }

    public String getProviderDescription() {
        return this.m_provider.getProviderInfo();
    }

    public int getTotalPageCount() {
        try {
            return this.m_provider.getAllPages().size();
        }
        catch (ProviderException e) {
            log.error((Object)"Unable to count pages: ", (Throwable)e);
            return -1;
        }
    }

    public boolean pageExists(String pageName) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        return this.m_provider.pageExists(pageName);
    }

    public boolean pageExists(String pageName, int version) throws ProviderException {
        if (pageName == null || pageName.length() == 0) {
            throw new ProviderException("Illegal page name");
        }
        if (version == -1) {
            return this.pageExists(pageName);
        }
        return this.m_provider.pageExists(pageName, version);
    }

    public void deleteVersion(WikiPage page) throws ProviderException {
        this.m_provider.deleteVersion(page.getName(), page.getVersion());
    }

    public void deletePage(WikiPage page) throws ProviderException {
        this.fireEvent(26, page.getName());
        this.m_provider.deletePage(page.getName());
        this.fireEvent(27, page.getName());
    }

    protected final void fireEvent(int type, String pagename) {
        if (WikiEventManager.isListening(this)) {
            WikiEventManager.fireEvent(this, new WikiPageEvent(this.m_engine, type, pagename));
        }
    }

    @Override
    public Collection<WikiModuleInfo> modules() {
        return null;
    }

    @Override
    public WikiModuleInfo getModuleInfo(String moduleName) {
        return null;
    }

    @Override
    public void actionPerformed(WikiEvent event) {
        if (!(event instanceof WikiSecurityEvent)) {
            return;
        }
        WikiSecurityEvent se = (WikiSecurityEvent)event;
        if (se.getType() == 54) {
            UserProfile[] profiles = (UserProfile[])se.getTarget();
            Principal[] oldPrincipals = new Principal[]{new WikiPrincipal(profiles[0].getLoginName()), new WikiPrincipal(profiles[0].getFullname()), new WikiPrincipal(profiles[0].getWikiName())};
            WikiPrincipal newPrincipal = new WikiPrincipal(profiles[1].getFullname());
            try {
                int pagesChanged = 0;
                Collection pages = this.getAllPages();
                for (WikiPage page : pages) {
                    boolean aclChanged = this.changeAcl(page, oldPrincipals, newPrincipal);
                    if (!aclChanged) continue;
                    try {
                        this.m_engine.getAclManager().setPermissions(page, page.getAcl());
                    }
                    catch (WikiSecurityException e) {
                        log.error((Object)("Could not change page ACL for page " + page.getName() + ": " + e.getMessage()), (Throwable)e);
                    }
                    ++pagesChanged;
                }
                log.info((Object)("Profile name change for '" + newPrincipal.toString() + "' caused " + pagesChanged + " page ACLs to change also."));
            }
            catch (ProviderException e) {
                log.error((Object)("Could not change user name in Page ACLs because of Provider error:" + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected boolean changeAcl(WikiPage page, Principal[] oldPrincipals, Principal newPrincipal) {
        Acl acl = page.getAcl();
        boolean pageChanged = false;
        if (acl != null) {
            Enumeration<AclEntry> entries = acl.entries();
            ArrayList<AclEntryImpl> entriesToAdd = new ArrayList<AclEntryImpl>();
            ArrayList<AclEntry> entriesToRemove = new ArrayList<AclEntry>();
            while (entries.hasMoreElements()) {
                AclEntry entry = entries.nextElement();
                if (!ArrayUtils.contains((Object[])oldPrincipals, (Object)entry.getPrincipal())) continue;
                AclEntryImpl aclEntryImpl = new AclEntryImpl();
                aclEntryImpl.setPrincipal(newPrincipal);
                Enumeration<Permission> permissions = entry.permissions();
                while (permissions.hasMoreElements()) {
                    Permission permission = permissions.nextElement();
                    aclEntryImpl.addPermission(permission);
                }
                pageChanged = true;
                entriesToRemove.add(entry);
                entriesToAdd.add(aclEntryImpl);
            }
            for (AclEntry aclEntry : entriesToRemove) {
                acl.removeEntry(aclEntry);
            }
            for (AclEntry aclEntry : entriesToAdd) {
                acl.addEntry(aclEntry);
            }
        }
        return pageChanged;
    }

    public static class SaveWikiPageTask
    extends Task {
        private static final long serialVersionUID = 3190559953484411420L;

        public SaveWikiPageTask() {
            super(PageManager.SAVE_TASK_MESSAGE_KEY);
        }

        @Override
        public Outcome execute() throws WikiException {
            WikiContext context = (WikiContext)this.getWorkflow().getAttribute(PageManager.PRESAVE_WIKI_CONTEXT);
            String proposedText = (String)this.getWorkflow().getAttribute(PageManager.FACT_PROPOSED_TEXT);
            WikiEngine engine = context.getEngine();
            WikiPage page = context.getPage();
            engine.getPageManager().putPageText(page, proposedText);
            engine.getPage(page.getName());
            engine.textToHTML(context, proposedText);
            Object fm = engine.getFilterManager();
            fm.doPostSaveFiltering(context, proposedText);
            return Outcome.STEP_COMPLETE;
        }
    }

    public static class PreSaveWikiPageTask
    extends Task {
        private static final long serialVersionUID = 6304715570092804615L;
        private final WikiContext m_context;
        private final String m_proposedText;

        public PreSaveWikiPageTask(WikiContext context, String proposedText) {
            super(PageManager.PRESAVE_TASK_MESSAGE_KEY);
            this.m_context = context;
            this.m_proposedText = proposedText;
        }

        @Override
        public Outcome execute() throws WikiException {
            Principal wup;
            WikiEngine engine = this.m_context.getEngine();
            Workflow workflow = this.getWorkflow();
            WikiPage page = this.m_context.getPage();
            if (page.getAuthor() == null && (wup = this.m_context.getCurrentUser()) != null) {
                page.setAuthor(wup.getName());
            }
            Object fm = engine.getFilterManager();
            String saveText = fm.doPreSaveFiltering(this.m_context, this.m_proposedText);
            workflow.setAttribute(PageManager.PRESAVE_WIKI_CONTEXT, this.m_context);
            workflow.setAttribute(PageManager.FACT_PROPOSED_TEXT, saveText);
            return Outcome.STEP_COMPLETE;
        }
    }

    private class LockReaper
    extends WikiBackgroundThread {
        public LockReaper(WikiEngine engine) {
            super(engine, 60);
            this.setName("JSPWiki Lock Reaper");
        }

        @Override
        public void backgroundTask() throws Exception {
            Collection<PageLock> entries = PageManager.this.m_pageLocks.values();
            Date now = new Date();
            Iterator<PageLock> i = entries.iterator();
            while (i.hasNext()) {
                PageLock p = i.next();
                if (!now.after(p.getExpiryTime())) continue;
                i.remove();
                log.debug((Object)("Reaped lock: " + p.getPage() + " by " + p.getLocker() + ", acquired " + p.getAcquisitionTime() + ", and expired " + p.getExpiryTime()));
            }
        }
    }
}

