/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import java.io.Serializable;
import java.util.Date;
import org.apache.wiki.WikiPage;

public class PageLock
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String m_page;
    private String m_locker;
    private Date m_lockAcquired;
    private Date m_lockExpiry;

    public PageLock(WikiPage page, String locker, Date acquired, Date expiry) {
        this.m_page = page.getName();
        this.m_locker = locker;
        this.m_lockAcquired = (Date)acquired.clone();
        this.m_lockExpiry = (Date)expiry.clone();
    }

    public String getPage() {
        return this.m_page;
    }

    public String getLocker() {
        return this.m_locker;
    }

    public Date getAcquisitionTime() {
        return this.m_lockAcquired;
    }

    public Date getExpiryTime() {
        return this.m_lockExpiry;
    }

    public long getTimeLeft() {
        long time = this.m_lockExpiry.getTime() - new Date().getTime();
        return time / 60000L + 1L;
    }
}

