/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.LoopControlPanel;
import org.apache.jmeter.gui.JBooleanPropertyEditor;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.AbstractThreadGroupSchema;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.ThreadGroupSchema;
import org.apache.jmeter.threads.gui.AbstractThreadGroupGui;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="threadgroup")
public class ThreadGroupGui
extends AbstractThreadGroupGui
implements ItemListener {
    private static final long serialVersionUID = 240L;
    private LoopControlPanel loopPanel;
    private static final String THREAD_NAME = "Thread Field";
    private static final String RAMP_NAME = "Ramp Up Field";
    private final JTextField threadInput = new JTextField();
    private final JTextField rampInput = new JTextField();
    private final boolean showDelayedStart;
    private JBooleanPropertyEditor delayedStart;
    private final JCheckBox scheduler = new JCheckBox(JMeterUtils.getResString("scheduler"));
    private final JTextField duration = new JTextField();
    private final JLabel durationLabel = JMeterUtils.labelFor(this.duration, "duration");
    private final JTextField delay = new JTextField();
    private final JLabel delayLabel = JMeterUtils.labelFor(this.delay, "delay");
    private final JBooleanPropertyEditor sameUserBox = new JBooleanPropertyEditor(AbstractThreadGroupSchema.INSTANCE.getSameUserOnNextIteration(), JMeterUtils.getResString("threadgroup_same_user"));

    public ThreadGroupGui() {
        this(true);
    }

    public ThreadGroupGui(boolean showDelayedStart) {
        this.showDelayedStart = showDelayedStart;
        this.init();
        this.initGui();
    }

    @Override
    public TestElement createTestElement() {
        ThreadGroup tg = new ThreadGroup();
        this.modifyTestElement(tg);
        return tg;
    }

    @Override
    public void modifyTestElement(TestElement tg) {
        super.configureTestElement(tg);
        if (tg instanceof AbstractThreadGroup) {
            ((AbstractThreadGroup)tg).setSamplerController((LoopController)this.loopPanel.createTestElement());
        }
        tg.set(AbstractThreadGroupSchema.INSTANCE.getNumThreads(), this.threadInput.getText());
        tg.setProperty("ThreadGroup.ramp_time", this.rampInput.getText());
        if (this.showDelayedStart) {
            this.delayedStart.updateElement(tg);
        }
        tg.setProperty(new BooleanProperty("ThreadGroup.scheduler", this.scheduler.isSelected()));
        tg.setProperty("ThreadGroup.duration", this.duration.getText());
        tg.setProperty("ThreadGroup.delay", this.delay.getText());
        this.sameUserBox.updateElement(tg);
    }

    @Override
    public void configure(TestElement tg) {
        super.configure(tg);
        this.threadInput.setText(tg.getString(AbstractThreadGroupSchema.INSTANCE.getNumThreads()));
        this.rampInput.setText(tg.getPropertyAsString("ThreadGroup.ramp_time"));
        this.loopPanel.configure((TestElement)tg.getProperty("ThreadGroup.main_controller").getObjectValue());
        if (this.showDelayedStart) {
            this.delayedStart.updateUi(tg);
        }
        this.scheduler.setSelected(tg.getPropertyAsBoolean("ThreadGroup.scheduler"));
        this.toggleSchedulerFields(this.scheduler.isSelected());
        this.duration.setText(tg.getPropertyAsString("ThreadGroup.duration"));
        this.delay.setText(tg.getPropertyAsString("ThreadGroup.delay"));
        this.sameUserBox.updateUi(tg);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getItem().equals(this.scheduler)) {
            this.toggleSchedulerFields(this.scheduler.isSelected());
        }
    }

    private void toggleSchedulerFields(boolean enable) {
        this.duration.setEnabled(enable);
        this.durationLabel.setEnabled(enable);
        this.delay.setEnabled(enable);
        this.delayLabel.setEnabled(enable);
    }

    private JPanel createControllerPanel() {
        this.loopPanel = new LoopControlPanel(false);
        LoopController looper = (LoopController)this.loopPanel.createTestElement();
        looper.setLoops(1);
        this.loopPanel.configure(looper);
        return this.loopPanel;
    }

    @Override
    public String getLabelResource() {
        return "threadgroup";
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.initGui();
    }

    private void initGui() {
        this.threadInput.setText("1");
        this.rampInput.setText("1");
        this.loopPanel.clearGui();
        if (this.showDelayedStart) {
            this.delayedStart.reset();
        }
        this.scheduler.setSelected(false);
        this.delay.setText("");
        this.duration.setText("");
        this.sameUserBox.reset();
    }

    private void init() {
        JPanel threadPropsPanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2", "[][fill,grow]"));
        threadPropsPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString("thread_properties")));
        threadPropsPanel.add(JMeterUtils.labelFor(this.threadInput, "number_of_threads"));
        this.threadInput.setName(THREAD_NAME);
        threadPropsPanel.add(this.threadInput);
        threadPropsPanel.add(JMeterUtils.labelFor(this.rampInput, "ramp_up"));
        this.rampInput.setName(RAMP_NAME);
        threadPropsPanel.add(this.rampInput);
        LoopControlPanel loopController = (LoopControlPanel)this.createControllerPanel();
        threadPropsPanel.add((Component)loopController.getLoopsLabel(), "split 2");
        threadPropsPanel.add((Component)loopController.getInfinite(), "gapleft push");
        threadPropsPanel.add(loopController.getLoops());
        threadPropsPanel.add((Component)((Object)this.sameUserBox), "span 2");
        if (this.showDelayedStart) {
            this.delayedStart = new JBooleanPropertyEditor(ThreadGroupSchema.INSTANCE.getDelayedStart(), JMeterUtils.getResString("delayed_start"));
            threadPropsPanel.add((Component)((Object)this.delayedStart), "span 2");
        }
        this.scheduler.addItemListener(this);
        threadPropsPanel.add((Component)this.scheduler, "span 2");
        threadPropsPanel.add(this.durationLabel);
        threadPropsPanel.add(this.duration);
        threadPropsPanel.add(this.delayLabel);
        threadPropsPanel.add(this.delay);
        this.add((Component)threadPropsPanel, "Center");
    }
}

