/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svg;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.observable.property.WritableProperty;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.vis.svg.SvgAttributeSpec;
import jetbrains.datalore.vis.svg.SvgColor;
import jetbrains.datalore.vis.svg.SvgColors;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgTransformBuilder;
import jetbrains.datalore.vis.svg.SvgTransformable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ5\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\rH\u0000\u00a2\u0006\u0002\b\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0006J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\bJ>\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006J\u0016\u0010&\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006J&\u0010&\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u0006J\u001e\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006J\u0016\u0010*\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006J\u0016\u0010+\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006J\u0016\u0010,\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010-\u001a\u00020.J\u0016\u0010,\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u0006J\u001e\u0010,\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Ljetbrains/datalore/vis/svg/SvgUtils;", "", "()V", "OPACITY_TABLE", "", "alpha2opacity", "", "colorAlpha", "", "colorAttributeTransform", "Ljetbrains/datalore/base/observable/property/WritableProperty;", "Ljetbrains/datalore/base/values/Color;", "color", "Ljetbrains/datalore/base/observable/property/Property;", "Ljetbrains/datalore/vis/svg/SvgColor;", "opacity", "colorAttributeTransform$vis_svg_portable", "copyAttributes", "", "source", "Ljetbrains/datalore/vis/svg/SvgElement;", "target", "c", "pngDataURI", "", "base64EncodedPngImage", "toARGB", "alpha", "r", "g", "b", "transformMatrix", "element", "Ljetbrains/datalore/vis/svg/SvgTransformable;", "a", "d", "e", "f", "transformRotate", "x", "y", "transformScale", "transformSkewX", "transformSkewY", "transformTranslate", "vector", "Ljetbrains/datalore/base/geometry/DoubleVector;", "vis-svg-portable"})
public final class SvgUtils {
    @NotNull
    public static final SvgUtils INSTANCE = new SvgUtils();
    @NotNull
    private static final double[] OPACITY_TABLE = new double[256];

    private SvgUtils() {
    }

    public final double opacity(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return OPACITY_TABLE[c.getAlpha()];
    }

    public final double alpha2opacity(int colorAlpha) {
        return OPACITY_TABLE[colorAlpha];
    }

    public final int toARGB(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return this.toARGB(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public final int toARGB(@NotNull Color c, double alpha) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        return this.toARGB(c.getRed(), c.getGreen(), c.getBlue(), (int)Math.max(0.0, Math.min(255.0, alpha * (double)255)));
    }

    public final int toARGB(int r, int g, int b2, int alpha) {
        int rgb = (r << 16) + (g << 8) + b2;
        return (alpha << 24) + rgb;
    }

    @NotNull
    public final WritableProperty<Color> colorAttributeTransform$vis_svg_portable(@NotNull Property<SvgColor> color, @NotNull Property<Double> opacity) {
        Intrinsics.checkNotNullParameter(color, (String)"color");
        Intrinsics.checkNotNullParameter(opacity, (String)"opacity");
        return new WritableProperty<Color>(color, opacity){
            final /* synthetic */ Property<SvgColor> $color;
            final /* synthetic */ Property<Double> $opacity;
            {
                this.$color = $color;
                this.$opacity = $opacity;
            }

            public void set(@Nullable Color value) {
                this.$color.set(SvgColors.Companion.create(value));
                if (value != null) {
                    this.$opacity.set(SvgUtils.INSTANCE.opacity(value));
                } else {
                    this.$opacity.set(1.0);
                }
            }
        };
    }

    public final void transformMatrix(@NotNull SvgTransformable element, double a2, double b2, double c, double d, double e, double f) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().matrix(a2, b2, c, d, e, f).build());
    }

    public final void transformTranslate(@NotNull SvgTransformable element, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().translate(x2, y2).build());
    }

    public final void transformTranslate(@NotNull SvgTransformable element, @NotNull DoubleVector vector) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        this.transformTranslate(element, vector.getX(), vector.getY());
    }

    public final void transformTranslate(@NotNull SvgTransformable element, double x2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().translate(x2).build());
    }

    public final void transformScale(@NotNull SvgTransformable element, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().scale(x2, y2).build());
    }

    public final void transformScale(@NotNull SvgTransformable element, double x2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().scale(x2).build());
    }

    public final void transformRotate(@NotNull SvgTransformable element, double a2, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().rotate(a2, x2, y2).build());
    }

    public final void transformRotate(@NotNull SvgTransformable element, double a2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().rotate(a2).build());
    }

    public final void transformSkewX(@NotNull SvgTransformable element, double a2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().skewX(a2).build());
    }

    public final void transformSkewY(@NotNull SvgTransformable element, double a2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.transform().set(new SvgTransformBuilder().skewY(a2).build());
    }

    public final void copyAttributes(@NotNull SvgElement source, @NotNull SvgElement target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        for (SvgAttributeSpec<?> attributeSpec : source.getAttributeKeys()) {
            Intrinsics.checkNotNull(attributeSpec, (String)"null cannot be cast to non-null type jetbrains.datalore.vis.svg.SvgAttributeSpec<kotlin.Any?>");
            SvgAttributeSpec<?> spec = attributeSpec;
            target.setAttribute(spec, source.getAttribute(attributeSpec).get());
        }
    }

    @NotNull
    public final String pngDataURI(@NotNull String base64EncodedPngImage) {
        Intrinsics.checkNotNullParameter((Object)base64EncodedPngImage, (String)"base64EncodedPngImage");
        String string = "data:image/png;base64," + base64EncodedPngImage;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"data:imag\u2026              .toString()");
        return string;
    }

    static {
        for (int alpha = 0; alpha < 256; ++alpha) {
            SvgUtils.OPACITY_TABLE[alpha] = (double)alpha / 255.0;
        }
    }
}

