/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.coord;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleRectangles;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.spatial.projections.Projection;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.coord.CoordProviderBase;
import jetbrains.datalore.plot.builder.coord.FixedRatioCoordProvider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J$\u0010\u000f\u001a\u00020\u00102\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/builder/coord/ProjectionCoordProvider;", "Ljetbrains/datalore/plot/builder/coord/CoordProviderBase;", "projection", "Ljetbrains/datalore/base/spatial/projections/Projection;", "xLim", "Ljetbrains/datalore/base/interval/DoubleSpan;", "yLim", "flipped", "", "(Ljetbrains/datalore/base/spatial/projections/Projection;Ljetbrains/datalore/base/interval/DoubleSpan;Ljetbrains/datalore/base/interval/DoubleSpan;Z)V", "adjustGeomSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "hDomain", "vDomain", "geomSize", "with", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "plot-builder-portable"})
public final class ProjectionCoordProvider
extends CoordProviderBase {
    public ProjectionCoordProvider(@NotNull Projection projection, @Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        super(xLim, yLim, flipped, projection);
    }

    @Override
    @NotNull
    public CoordProvider with(@Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped) {
        return new ProjectionCoordProvider(this.getProjection(), xLim, yLim, flipped);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DoubleVector adjustGeomSize(@NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull DoubleVector geomSize) {
        void $this$mapTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        Object object = new DoubleVector[]{new DoubleVector(hDomain.getLowerEnd(), vDomain.getLowerEnd()), new DoubleVector(hDomain.getLowerEnd(), vDomain.getUpperEnd()), new DoubleVector(hDomain.getUpperEnd(), vDomain.getLowerEnd()), new DoubleVector(hDomain.getUpperEnd(), vDomain.getUpperEnd())};
        object = CollectionsKt.listOf((Object[])object);
        DoubleRectangles doubleRectangles = DoubleRectangles.INSTANCE;
        boolean $i$f$map22 = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            DoubleVector doubleVector = (DoubleVector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getFlipped() ? it.flip() : it);
        }
        $this$map$iv = (List)destination$iv$iv;
        Projection $i$f$map22 = this.getProjection();
        boolean $i$f$mapNotNull22 = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator bl = $this$forEach$iv$iv$iv.iterator();
        while (bl.hasNext()) {
            DoubleVector it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = bl.next();
            boolean bl2 = false;
            DoubleVector p0 = (DoubleVector)element$iv$iv;
            boolean bl3 = false;
            if ($i$f$map22.project(p0) == null) continue;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNull22 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DoubleVector $i$f$forEach2 = (DoubleVector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(this.getFlipped() ? it.flip() : it);
        }
        DoubleRectangle doubleRectangle = doubleRectangles.boundingBox((List)destination$iv$iv);
        if (doubleRectangle == null) {
            throw new IllegalStateException("adjustGeomSize() - can't compute bbox".toString());
        }
        DoubleRectangle bbox2 = doubleRectangle;
        double domainRatio = bbox2.getWidth() / bbox2.getHeight();
        return FixedRatioCoordProvider.Companion.reshapeGeom(geomSize, domainRatio);
    }
}

