/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.tile;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.layout.GeomMarginsLayout;
import jetbrains.datalore.plot.builder.layout.util.GeomAreaInsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Ljetbrains/datalore/plot/builder/layout/tile/TileLayoutUtil;", "", "()V", "geomOuterBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "geomInsets", "Ljetbrains/datalore/plot/builder/layout/util/GeomAreaInsets;", "plotSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "hDomain", "Ljetbrains/datalore/base/interval/DoubleSpan;", "vDomain", "marginsLayout", "Ljetbrains/datalore/plot/builder/layout/GeomMarginsLayout;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "liveMapGeomBounds", "plot-builder-portable"})
public final class TileLayoutUtil {
    @NotNull
    public static final TileLayoutUtil INSTANCE = new TileLayoutUtil();

    private TileLayoutUtil() {
    }

    @NotNull
    public final DoubleRectangle liveMapGeomBounds(@NotNull DoubleVector plotSize) {
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        return new DoubleRectangle(DoubleVector.Companion.getZERO(), plotSize);
    }

    @NotNull
    public final DoubleRectangle geomOuterBounds(@NotNull GeomAreaInsets geomInsets, @NotNull DoubleVector plotSize, @NotNull DoubleSpan hDomain, @NotNull DoubleSpan vDomain, @NotNull GeomMarginsLayout marginsLayout, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)geomInsets, (String)"geomInsets");
        Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
        Intrinsics.checkNotNullParameter((Object)hDomain, (String)"hDomain");
        Intrinsics.checkNotNullParameter((Object)vDomain, (String)"vDomain");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        DoubleRectangle plottingArea = geomInsets.subtractFrom(new DoubleRectangle(DoubleVector.Companion.getZERO(), plotSize));
        DoubleVector geomInnerSize = marginsLayout.toInnerSize(plottingArea.getDimension());
        DoubleVector it = coordProvider.adjustGeomSize(hDomain, vDomain, geomInnerSize);
        boolean bl = false;
        DoubleVector geomOuterSizeAdjusted = marginsLayout.toOuterSize(it);
        return new DoubleRectangle(plottingArea.getOrigin(), geomOuterSizeAdjusted);
    }
}

