/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.figure.plot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.FrameOfReferenceProvider;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.assemble.PlotAssemblerUtil;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.LegendBoxesLayoutUtil;
import jetbrains.datalore.plot.builder.layout.LegendsBlockInfo;
import jetbrains.datalore.plot.builder.layout.PlotLabelSpecFactory;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayoutUtil;
import jetbrains.datalore.plot.builder.layout.figure.plot.PlotFigureLayoutInfo;
import jetbrains.datalore.plot.builder.layout.tile.LiveMapAxisTheme;
import jetbrains.datalore.plot.builder.layout.tile.LiveMapTileLayoutProvider;
import jetbrains.datalore.plot.builder.presentation.LabelSpec;
import jetbrains.datalore.plot.builder.scale.AxisPosition;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u008f\u0001\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0017J\u001a\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020\u0019H\u0002J\u000e\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020#J\u000e\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020#R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ljetbrains/datalore/plot/builder/layout/figure/plot/PlotFigureLayouter;", "", "coreLayersByTile", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "marginalLayersByTile", "frameProviderByTile", "Ljetbrains/datalore/plot/builder/FrameOfReferenceProvider;", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "hAxisPosition", "Ljetbrains/datalore/plot/builder/scale/AxisPosition;", "vAxisPosition", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "legendBoxInfos", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "title", "", "subtitle", "caption", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljetbrains/datalore/plot/builder/assemble/PlotFacets;Ljetbrains/datalore/plot/builder/coord/CoordProvider;Ljetbrains/datalore/plot/builder/scale/AxisPosition;Ljetbrains/datalore/plot/builder/scale/AxisPosition;Ljetbrains/datalore/plot/builder/theme/Theme;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "axisEnabled", "", "containsLiveMap", "flipAxis", "hAxisTitle", "legendsBlockInfo", "Ljetbrains/datalore/plot/builder/layout/LegendsBlockInfo;", "vAxisTitle", "createFigureLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/figure/plot/PlotFigureLayoutInfo;", "figurePreferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plotLayoutInfo", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "createLiveMapPlotLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "createPlotLayout", "insideOut", "layoutByGeomSize", "geomSize", "layoutByOuterSize", "outerSize", "plot-builder-portable"})
public final class PlotFigureLayouter {
    @NotNull
    private final List<List<GeomLayer>> coreLayersByTile;
    @NotNull
    private final List<List<GeomLayer>> marginalLayersByTile;
    @NotNull
    private final List<FrameOfReferenceProvider> frameProviderByTile;
    @NotNull
    private final PlotFacets facets;
    @NotNull
    private final CoordProvider coordProvider;
    @NotNull
    private final AxisPosition hAxisPosition;
    @NotNull
    private final AxisPosition vAxisPosition;
    @NotNull
    private final Theme theme;
    @NotNull
    private final List<LegendBoxInfo> legendBoxInfos;
    @Nullable
    private String title;
    @Nullable
    private String subtitle;
    @Nullable
    private String caption;
    private final boolean flipAxis;
    private final boolean containsLiveMap;
    @Nullable
    private final String hAxisTitle;
    @Nullable
    private final String vAxisTitle;
    private final boolean axisEnabled;
    @NotNull
    private final LegendsBlockInfo legendsBlockInfo;

    /*
     * WARNING - void declaration
     */
    public PlotFigureLayouter(@NotNull List<? extends List<? extends GeomLayer>> coreLayersByTile, @NotNull List<? extends List<? extends GeomLayer>> marginalLayersByTile, @NotNull List<? extends FrameOfReferenceProvider> frameProviderByTile, @NotNull PlotFacets facets, @NotNull CoordProvider coordProvider, @NotNull AxisPosition hAxisPosition, @NotNull AxisPosition vAxisPosition, @NotNull Theme theme, @NotNull List<? extends LegendBoxInfo> legendBoxInfos, @Nullable String title, @Nullable String subtitle, @Nullable String caption) {
        boolean bl;
        boolean bl2;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter(coreLayersByTile, (String)"coreLayersByTile");
            Intrinsics.checkNotNullParameter(marginalLayersByTile, (String)"marginalLayersByTile");
            Intrinsics.checkNotNullParameter(frameProviderByTile, (String)"frameProviderByTile");
            Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
            Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
            Intrinsics.checkNotNullParameter((Object)((Object)hAxisPosition), (String)"hAxisPosition");
            Intrinsics.checkNotNullParameter((Object)((Object)vAxisPosition), (String)"vAxisPosition");
            Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
            Intrinsics.checkNotNullParameter(legendBoxInfos, (String)"legendBoxInfos");
            this.coreLayersByTile = coreLayersByTile;
            this.marginalLayersByTile = marginalLayersByTile;
            this.frameProviderByTile = frameProviderByTile;
            this.facets = facets;
            this.coordProvider = coordProvider;
            this.hAxisPosition = hAxisPosition;
            this.vAxisPosition = vAxisPosition;
            this.theme = theme;
            this.legendBoxInfos = legendBoxInfos;
            this.title = title;
            this.subtitle = subtitle;
            this.caption = caption;
            this.flipAxis = this.coordProvider.getFlipped();
            Iterable iterable = CollectionsKt.flatten((Iterable)this.coreLayersByTile);
            PlotFigureLayouter plotFigureLayouter = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GeomLayer p0 = (GeomLayer)element$iv;
                    boolean bl3 = false;
                    if (!p0.isLiveMap()) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        plotFigureLayouter.containsLiveMap = bl = bl2;
        this.hAxisTitle = this.frameProviderByTile.get(0).getHAxisLabel();
        this.vAxisTitle = this.frameProviderByTile.get(0).getVAxisLabel();
        this.axisEnabled = !this.containsLiveMap;
        LegendTheme legendTheme = this.theme.legend();
        this.legendsBlockInfo = LegendBoxesLayoutUtil.INSTANCE.arrangeLegendBoxes(this.legendBoxInfos, legendTheme);
    }

    @NotNull
    public final PlotFigureLayoutInfo layoutByOuterSize(@NotNull DoubleVector outerSize) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)outerSize, (String)"outerSize");
        if (this.containsLiveMap) {
            DoubleRectangle figBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), outerSize);
            doubleVector = PlotLayoutUtil.INSTANCE.liveMapBounds(figBounds).getDimension();
        } else {
            doubleVector = outerSize;
        }
        DoubleVector figureBaseSize = doubleVector;
        DoubleVector plotPreferredSize = PlotLayoutUtil.INSTANCE.subtractTitlesAndLegends(figureBaseSize, this.title, this.subtitle, this.caption, this.hAxisTitle, this.vAxisTitle, this.axisEnabled, this.legendsBlockInfo, this.theme, this.flipAxis);
        PlotLayout plotLayout = this.createPlotLayout(false);
        PlotLayoutInfo layoutInfo = plotLayout.doLayout(plotPreferredSize, this.coordProvider);
        return this.createFigureLayoutInfo(outerSize, layoutInfo);
    }

    @NotNull
    public final PlotFigureLayoutInfo layoutByGeomSize(@NotNull DoubleVector geomSize) {
        Intrinsics.checkNotNullParameter((Object)geomSize, (String)"geomSize");
        PlotLayout plotLayout = this.createPlotLayout(true);
        PlotLayoutInfo layoutInfo = plotLayout.doLayout(geomSize, this.coordProvider);
        return this.createFigureLayoutInfo(null, layoutInfo);
    }

    /*
     * WARNING - void declaration
     */
    private final PlotLayout createPlotLayout(boolean insideOut) {
        PlotLayout plotLayout;
        if (this.containsLiveMap) {
            plotLayout = this.createLiveMapPlotLayout();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.frameProviderByTile;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FrameOfReferenceProvider frameOfReferenceProvider = (FrameOfReferenceProvider)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.createTileLayoutProvider());
            }
            List layoutProviderByTile = (List)destination$iv$iv;
            plotLayout = PlotAssemblerUtil.INSTANCE.createPlotLayout(layoutProviderByTile, insideOut, this.facets, this.theme.facets(), this.hAxisPosition, this.vAxisPosition, this.theme.horizontalAxis(this.flipAxis), this.theme.verticalAxis(this.flipAxis));
        }
        return plotLayout;
    }

    /*
     * WARNING - void declaration
     */
    private final PlotLayout createLiveMapPlotLayout() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.coreLayersByTile;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LiveMapTileLayoutProvider());
        }
        List layoutProviderByTile = (List)destination$iv$iv;
        return PlotAssemblerUtil.INSTANCE.createPlotLayout(layoutProviderByTile, false, this.facets, this.theme.facets(), AxisPosition.BOTTOM, AxisPosition.LEFT, new LiveMapAxisTheme(), new LiveMapAxisTheme());
    }

    private final PlotFigureLayoutInfo createFigureLayoutInfo(DoubleVector figurePreferredSize, PlotLayoutInfo plotLayoutInfo) {
        DoubleRectangle doubleRectangle;
        DoubleVector plotSize = plotLayoutInfo.getSize();
        DoubleVector figureLayoutedSize = PlotLayoutUtil.INSTANCE.addTitlesAndLegends(plotSize, this.title, this.subtitle, this.caption, this.hAxisTitle, this.vAxisTitle, this.axisEnabled, this.legendsBlockInfo, this.theme, this.flipAxis);
        if (figurePreferredSize == null) {
            doubleRectangle = new DoubleRectangle(DoubleVector.Companion.getZERO(), figureLayoutedSize);
        } else {
            DoubleRectangle figurePreferredBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), figurePreferredSize);
            DoubleVector delta = figurePreferredBounds.getCenter().subtract(new DoubleRectangle(figurePreferredBounds.getOrigin(), figureLayoutedSize).getCenter());
            DoubleVector deltaApplied = new DoubleVector(Math.max(0.0, delta.getX()), Math.max(0.0, delta.getY()));
            DoubleVector plotOuterOrigin = figurePreferredBounds.getOrigin().add(deltaApplied);
            doubleRectangle = new DoubleRectangle(plotOuterOrigin, figureLayoutedSize);
        }
        DoubleRectangle figureLayoutedBounds = doubleRectangle;
        PlotFigureLayouter it = this;
        boolean bl = false;
        DoubleVector titleSizeDelta = PlotLayoutUtil.INSTANCE.titleSizeDelta(this.title, this.subtitle, this.theme.plot());
        DoubleVector captionSizeDelta = PlotLayoutUtil.INSTANCE.captionSizeDelta(this.caption, this.theme.plot());
        DoubleRectangle figureBoundsWithoutTitleAndCaption = new DoubleRectangle(figureLayoutedBounds.getOrigin().add(titleSizeDelta), figureLayoutedBounds.getDimension().subtract(titleSizeDelta).subtract(captionSizeDelta));
        DoubleVector plotOrigin = figureBoundsWithoutTitleAndCaption.getOrigin().add(PlotLayoutUtil.INSTANCE.legendBlockLeftTopDelta(this.legendsBlockInfo, this.theme.legend())).add(PlotLayoutUtil.INSTANCE.axisTitlesOriginOffset((Pair<String, ? extends LabelSpec>)TuplesKt.to((Object)this.hAxisTitle, (Object)PlotLabelSpecFactory.INSTANCE.axisTitle(this.theme.horizontalAxis(this.flipAxis))), (Pair<String, ? extends LabelSpec>)TuplesKt.to((Object)this.vAxisTitle, (Object)PlotLabelSpecFactory.INSTANCE.axisTitle(this.theme.verticalAxis(this.flipAxis))), plotLayoutInfo.getHasTopAxisTitle(), plotLayoutInfo.getHasLeftAxisTitle(), this.axisEnabled, PlotLayoutUtil.INSTANCE.axisMarginDimensions(this.theme, this.flipAxis)));
        DoubleRectangle geomAreaBounds = PlotLayoutUtil.INSTANCE.overallGeomBounds(plotLayoutInfo).add(plotOrigin);
        DoubleVector doubleVector = figurePreferredSize;
        if (doubleVector == null) {
            doubleVector = figureLayoutedBounds.getDimension();
        }
        return new PlotFigureLayoutInfo(figureLayoutedBounds, figureBoundsWithoutTitleAndCaption, plotOrigin, geomAreaBounds, doubleVector, plotLayoutInfo, this.legendsBlockInfo);
    }
}

