/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u000b\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\"H\u0000\u00a2\u0006\u0002\b#J\u0012\u0010$\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0012\u0010%\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0015\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020 H\u0000\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\u0003R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Ljetbrains/datalore/plot/builder/assemble/StitchedPlotLayer;", "", "geomLayers", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "(Ljava/util/List;)V", "aestheticsDefaults", "Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "getAestheticsDefaults", "()Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "colorByAes", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/base/values/Color;", "getColorByAes", "()Ljetbrains/datalore/plot/base/Aes;", "fillByAes", "getFillByAes", "isLegendDisabled", "", "()Z", "isYOrientation", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getConstant", "T", "aes", "(Ljetbrains/datalore/plot/base/Aes;)Ljava/lang/Object;", "getDataRange", "Ljetbrains/datalore/base/interval/DoubleSpan;", "variable", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "getVariables", "", "getVariables$plot_builder_portable", "hasBinding", "hasConstant", "hasVariable", "v", "hasVariable$plot_builder_portable", "isNumericData", "renderedAes", "plot-builder-portable"})
public final class StitchedPlotLayer {
    @NotNull
    private final List<GeomLayer> geomLayers;

    public StitchedPlotLayer(@NotNull List<? extends GeomLayer> geomLayers) {
        Intrinsics.checkNotNullParameter(geomLayers, (String)"geomLayers");
        this.geomLayers = geomLayers;
    }

    public final boolean isYOrientation() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).isYOrientation();
    }

    @NotNull
    public final LegendKeyElementFactory getLegendKeyElementFactory() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getLegendKeyElementFactory();
    }

    @NotNull
    public final AestheticsDefaults getAestheticsDefaults() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getAestheticsDefaults();
    }

    public final boolean isLegendDisabled() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).isLegendDisabled();
    }

    @NotNull
    public final Aes<Color> getColorByAes() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getColorByAes();
    }

    @NotNull
    public final Aes<Color> getFillByAes() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getFillByAes();
    }

    @NotNull
    public final List<Aes<?>> renderedAes() {
        return this.geomLayers.isEmpty() ? CollectionsKt.emptyList() : this.geomLayers.get(0).renderedAes();
    }

    public final boolean hasBinding(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return !((Collection)this.geomLayers).isEmpty() && this.geomLayers.get(0).hasBinding(aes);
    }

    public final boolean hasConstant(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        return !((Collection)this.geomLayers).isEmpty() && this.geomLayers.get(0).hasConstant(aes);
    }

    public final <T> T getConstant(@NotNull Aes<T> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getConstant(aes);
    }

    @Nullable
    public final DoubleSpan getDataRange(@NotNull DataFrame.Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (!this.isNumericData(variable)) {
            boolean bl = false;
            String string = "Not numeric data [" + variable + ']';
            throw new IllegalStateException(string.toString());
        }
        DoubleSpan result = null;
        for (GeomLayer layer : this.geomLayers) {
            DoubleSpan range = layer.getDataFrame().range(variable);
            result = SeriesUtil.INSTANCE.span(result, range);
        }
        return result;
    }

    private final boolean isNumericData(DataFrame.Variable variable) {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        for (GeomLayer layer : this.geomLayers) {
            if (layer.getDataFrame().isNumeric(variable)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final Set<DataFrame.Variable> getVariables$plot_builder_portable() {
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getDataFrame().variables();
    }

    public final boolean hasVariable$plot_builder_portable(@NotNull DataFrame.Variable v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (!(!((Collection)this.geomLayers).isEmpty())) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return this.geomLayers.get(0).getDataFrame().has(v);
    }
}

