/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.chunks;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.formatting.datetime.DateTimeFormat;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.Month;
import org.jetbrains.letsPlot.commons.intern.datetime.Time;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngHelperInternal;
import org.jetbrains.letsPlot.util.pngj.PngjException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunk;
import org.jetbrains.letsPlot.util.pngj.chunks.PngChunkSingle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0016J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\nJ6\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u001cR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTIME;", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkSingle;", "info", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "asString", "", "getAsString", "()Ljava/lang/String;", "dateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "orderingConstraint", "Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "getOrderingConstraint", "()Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunk$ChunkOrderingConstraint;", "yMDHMS", "", "getYMDHMS", "()[I", "createRawChunk", "Lorg/jetbrains/letsPlot/util/pngj/chunks/ChunkRaw;", "parseFromRaw", "", "chunk", "setNow", "now", "setYMDHMS", "yearx", "", "monx", "dayx", "hourx", "minx", "secx", "Companion", "plot-api"})
@SourceDebugExtension(value={"SMAP\nPngChunkTIME.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PngChunkTIME.kt\norg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTIME\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class PngChunkTIME
extends PngChunkSingle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DateTime dateTime;
    @NotNull
    public static final String ID = "tIME";

    public PngChunkTIME(@Nullable ImageInfo info) {
        super(ID, info);
    }

    @Override
    @NotNull
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.NONE;
    }

    @Override
    @NotNull
    public ChunkRaw createRawChunk() {
        ChunkRaw c = this.createEmptyChunk(7, true);
        DateTime dateTime = this.dateTime;
        PngHelperInternal.INSTANCE.writeInt2tobytes(dateTime != null ? dateTime.getYear() : 0, c.getData(), 0);
        byte[] byArray = c.getData();
        Intrinsics.checkNotNull((Object)byArray);
        DateTime dateTime2 = this.dateTime;
        byArray[2] = (byte)((dateTime2 != null && (dateTime2 = dateTime2.getMonth()) != null ? dateTime2.ordinal() : 0) + 1);
        byte[] byArray2 = c.getData();
        Intrinsics.checkNotNull((Object)byArray2);
        DateTime dateTime3 = this.dateTime;
        byArray2[3] = dateTime3 != null ? (byte)dateTime3.getDay() : (byte)0;
        byte[] byArray3 = c.getData();
        Intrinsics.checkNotNull((Object)byArray3);
        DateTime dateTime4 = this.dateTime;
        byArray3[4] = dateTime4 != null ? (byte)dateTime4.getHours() : (byte)0;
        byte[] byArray4 = c.getData();
        Intrinsics.checkNotNull((Object)byArray4);
        DateTime dateTime5 = this.dateTime;
        byArray4[5] = dateTime5 != null ? (byte)dateTime5.getMinutes() : (byte)0;
        byte[] byArray5 = c.getData();
        Intrinsics.checkNotNull((Object)byArray5);
        DateTime dateTime6 = this.dateTime;
        byArray5[6] = dateTime6 != null ? (byte)dateTime6.getSeconds() : (byte)0;
        return c;
    }

    @Override
    public void parseFromRaw(@NotNull ChunkRaw chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        if (chunk.getLen() != 7) {
            throw new PngjException("bad chunk " + chunk);
        }
        this.setYMDHMS(PngHelperInternal.INSTANCE.readInt2fromBytes(chunk.getData(), 0), PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 2), PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 3), PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 4), PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 5), PngHelperInternal.INSTANCE.readInt1fromByte(chunk.getData(), 6));
    }

    public final void setNow(@NotNull DateTime now) {
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        this.dateTime = now;
    }

    public final void setYMDHMS(int yearx, int monx, int dayx, int hourx, int minx, int secx) {
        this.dateTime = new DateTime(new Date(dayx, Month.Companion.values()[monx - 1], yearx), new Time(hourx, minx, secx, 0, 8, null));
    }

    @NotNull
    public final int[] getYMDHMS() {
        int[] nArray;
        DateTime dateTime = this.dateTime;
        if (dateTime != null) {
            DateTime it = dateTime;
            boolean bl = false;
            int[] nArray2 = new int[]{it.getYear(), it.getMonth().ordinal() + 1, it.getDay(), it.getHours(), it.getMinutes(), it.getSeconds()};
            nArray = nArray2;
        } else {
            nArray = new int[6];
        }
        return nArray;
    }

    @NotNull
    public final String getAsString() {
        Object object;
        block3: {
            block2: {
                object = this.dateTime;
                if (object == null) break block2;
                DateTime dateTime = object;
                DateTimeFormat dateTimeFormat = new DateTimeFormat("%Y/%m/%d %H:%M:%S");
                DateTime p0 = dateTime;
                boolean bl = false;
                String string = dateTimeFormat.apply(p0);
                object = string;
                if (string != null) break block3;
            }
            object = "--/--/-- --:--:--";
        }
        return object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/chunks/PngChunkTIME$Companion;", "", "()V", "ID", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

