/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.util.Objects;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleSelector;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.apache.jmeter.report.processor.Aggregator;
import org.apache.jmeter.report.processor.ValueResultData;

public class AggregateConsumer
extends AbstractSampleConsumer {
    private final Aggregator aggregator;
    private final SampleSelector<Double> selector;

    public final Aggregator getAggregator() {
        return this.aggregator;
    }

    public final SampleSelector<Double> getSelector() {
        return this.selector;
    }

    public AggregateConsumer(Aggregator aggregator, SampleSelector<Double> selector) {
        Objects.requireNonNull(aggregator, "aggregator must not be null");
        Objects.requireNonNull(selector, "selector must not be null");
        this.aggregator = aggregator;
        this.selector = selector;
    }

    @Override
    public void startConsuming() {
        int channelCount = this.getConsumedChannelCount();
        for (int i = 0; i < channelCount; ++i) {
            super.setProducedMetadata(this.getConsumedMetadata(i), i);
        }
        super.startProducing();
    }

    @Override
    public void consume(Sample sample, int channel) {
        this.aggregator.addValue(this.selector.select(sample));
        super.produce(sample, channel);
    }

    @Override
    public void stopConsuming() {
        this.setDataToContext(this.getName(), new ValueResultData(this.aggregator.getResult()));
        super.stopProducing();
    }
}

