/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale;

import java.util.List;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.ScaleMapper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/scale/MapperUtil;", "", "()V", "map", "Ljetbrains/datalore/base/interval/DoubleSpan;", "r", "mapper", "Ljetbrains/datalore/plot/base/ScaleMapper;", "", "rangeWithLimitsAfterTransform", "dataRange", "trans", "Ljetbrains/datalore/plot/base/ContinuousTransform;", "plot-base-portable"})
public final class MapperUtil {
    @NotNull
    public static final MapperUtil INSTANCE = new MapperUtil();

    private MapperUtil() {
    }

    @NotNull
    public final DoubleSpan map(@NotNull DoubleSpan r, @NotNull ScaleMapper<Double> mapper) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Double d = mapper.invoke(r.getLowerEnd());
        Intrinsics.checkNotNull((Object)d);
        double a2 = ((Number)d).doubleValue();
        Double d2 = mapper.invoke(r.getUpperEnd());
        Intrinsics.checkNotNull((Object)d2);
        double b2 = ((Number)d2).doubleValue();
        return new DoubleSpan(Math.min(a2, b2), Math.max(a2, b2));
    }

    @NotNull
    public final DoubleSpan rangeWithLimitsAfterTransform(@NotNull DoubleSpan dataRange, @NotNull ContinuousTransform trans) {
        Intrinsics.checkNotNullParameter((Object)dataRange, (String)"dataRange");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        if (!trans.isInDomain(dataRange.getLowerEnd())) {
            boolean $i$a$-check-MapperUtil$rangeWithLimitsAfterTransform$32 = false;
            String $i$a$-check-MapperUtil$rangeWithLimitsAfterTransform$32 = '[' + Reflection.getOrCreateKotlinClass(trans.getClass()).getSimpleName() + "] Lower end " + dataRange.getLowerEnd() + " is outside of transform's domain.";
            throw new IllegalStateException($i$a$-check-MapperUtil$rangeWithLimitsAfterTransform$32.toString());
        }
        if (!trans.isInDomain(dataRange.getUpperEnd())) {
            boolean bl = false;
            String string = '[' + Reflection.getOrCreateKotlinClass(trans.getClass()).getSimpleName() + "] Upper end " + dataRange.getUpperEnd() + " is outside of transform's domain.";
            throw new IllegalStateException(string.toString());
        }
        Object[] objectArray = new Double[]{trans.apply((Double)trans.definedLimits().getFirst()), trans.apply((Double)trans.definedLimits().getSecond()), trans.apply(dataRange.getLowerEnd()), trans.apply(dataRange.getUpperEnd())};
        List transformedLimits = CollectionsKt.listOf((Object[])objectArray);
        return DoubleSpan.Companion.encloseAll((Iterable)transformedLimits);
    }
}

