/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.UnmodifiableJMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public final class JMeterContextService {
    private static final ThreadLocal<JMeterContext> threadContext = ThreadLocal.withInitial(JMeterContext::new);
    private static final AtomicLong testStart = new AtomicLong();
    private static final AtomicInteger NUMBER_OF_ACTIVE_THREADS = new AtomicInteger();
    private static final AtomicInteger NUMBER_OF_THREADS_STARTED = new AtomicInteger();
    private static final AtomicInteger NUMBER_OF_THREADS_FINISHED = new AtomicInteger();
    private static final AtomicInteger TOTAL_THREADS = new AtomicInteger();
    private static UnmodifiableJMeterVariables variables;

    private JMeterContextService() {
    }

    public static JMeterContext getContext() {
        return threadContext.get();
    }

    static void removeContext() {
        threadContext.remove();
    }

    public static void replaceContext(JMeterContext context) {
        threadContext.remove();
        threadContext.set(context);
    }

    public static synchronized void startTest() {
        if (testStart.get() == 0L) {
            NUMBER_OF_ACTIVE_THREADS.set(0);
            testStart.set(System.currentTimeMillis());
            JMeterUtils.setProperty("TESTSTART.MS", Long.toString(testStart.get()));
        }
    }

    static void incrNumberOfThreads() {
        NUMBER_OF_ACTIVE_THREADS.incrementAndGet();
        NUMBER_OF_THREADS_STARTED.incrementAndGet();
    }

    static void decrNumberOfThreads() {
        NUMBER_OF_ACTIVE_THREADS.decrementAndGet();
        NUMBER_OF_THREADS_FINISHED.incrementAndGet();
    }

    public static int getNumberOfThreads() {
        return NUMBER_OF_ACTIVE_THREADS.get();
    }

    public static ThreadCounts getThreadCounts() {
        return new ThreadCounts(NUMBER_OF_ACTIVE_THREADS.get(), NUMBER_OF_THREADS_STARTED.get(), NUMBER_OF_THREADS_FINISHED.get());
    }

    public static synchronized void endTest() {
        testStart.set(0L);
        JMeterContextService.resetClientSideVariables();
    }

    public static long getTestStartTime() {
        return testStart.get();
    }

    public static int getTotalThreads() {
        return TOTAL_THREADS.get();
    }

    public static void addTotalThreads(int thisGroup) {
        TOTAL_THREADS.addAndGet(thisGroup);
    }

    public static void clearTotalThreads() {
        TOTAL_THREADS.set(0);
        NUMBER_OF_THREADS_STARTED.set(0);
        NUMBER_OF_THREADS_FINISHED.set(0);
    }

    public static JMeterVariables getClientSideVariables() {
        return variables;
    }

    public static void initClientSideVariables(JMeterVariables clientSideVariables) {
        variables = new UnmodifiableJMeterVariables(clientSideVariables);
    }

    public static void resetClientSideVariables() {
        variables = null;
    }

    public static class ThreadCounts {
        public final int activeThreads;
        public final int startedThreads;
        public final int finishedThreads;

        ThreadCounts(int active, int started, int finished) {
            this.activeThreads = active;
            this.startedThreads = started;
            this.finishedThreads = finished;
        }
    }
}

