/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.RealDistribution;
import jetbrains.datalore.plot.base.stat.math3.UnivariateFunction;
import jetbrains.datalore.plot.base.stat.math3.UnivariateSolverUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/AbstractRealDistribution;", "Ljetbrains/datalore/plot/base/stat/math3/RealDistribution;", "()V", "solverAbsoluteAccuracy", "", "getSolverAbsoluteAccuracy", "()D", "cumulativeProbability", "x0", "x1", "inverseCumulativeProbability", "p", "Companion", "plot-base-portable"})
public abstract class AbstractRealDistribution
implements RealDistribution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double solverAbsoluteAccuracy = SOLVER_DEFAULT_ABSOLUTE_ACCURACY;
    private static final double SOLVER_DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    private static final long serialVersionUID = -38038050983108802L;

    protected AbstractRealDistribution() {
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double cumulativeProbability(double x0, double x1) {
        if (x0 > x1) {
            throw new IllegalStateException(("NumberIsTooLarge - x0:" + x0 + ", x1:" + x1).toString());
        }
        return this.cumulativeProbability(x1) - this.cumulativeProbability(x0);
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        double dx;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalStateException(("OutOfRange [0, 1] - p" + p).toString());
        }
        double lowerBound = this.getSupportLowerBound();
        if (p == 0.0) {
            return lowerBound;
        }
        double upperBound = this.getSupportUpperBound();
        if (p == 1.0) {
            return upperBound;
        }
        double mu = this.getNumericalMean();
        double sig = Math.sqrt(this.getNumericalVariance());
        boolean chebyshevApplies = false;
        chebyshevApplies = !Double.isInfinite(mu) && !Double.isNaN(mu) && !Double.isInfinite(sig) && !Double.isNaN(sig);
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            if (chebyshevApplies) {
                lowerBound = mu - sig * Math.sqrt((1.0 - p) / p);
            } else {
                lowerBound = -1.0;
                while (this.cumulativeProbability(lowerBound) >= p) {
                    lowerBound *= 2.0;
                }
            }
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            if (chebyshevApplies) {
                upperBound = mu + sig * Math.sqrt(p / (1.0 - p));
            } else {
                upperBound = 1.0;
                while (this.cumulativeProbability(upperBound) < p) {
                    upperBound *= 2.0;
                }
            }
        }
        UnivariateFunction toSolve2 = new UnivariateFunction(this, p){
            final /* synthetic */ AbstractRealDistribution this$0;
            final /* synthetic */ double $p;
            {
                this.this$0 = $receiver;
                this.$p = $p;
            }

            public double value(double x) {
                return this.this$0.cumulativeProbability(x) - this.$p;
            }
        };
        double x = UnivariateSolverUtils.INSTANCE.solve(toSolve2, lowerBound, upperBound, this.getSolverAbsoluteAccuracy());
        if (!this.isSupportConnected() && x - (dx = this.getSolverAbsoluteAccuracy()) >= this.getSupportLowerBound()) {
            double px = this.cumulativeProbability(x);
            if (this.cumulativeProbability(x - dx) == px) {
                upperBound = x;
                while (upperBound - lowerBound > dx) {
                    double midPoint = 0.5 * (lowerBound + upperBound);
                    if (this.cumulativeProbability(midPoint) < px) {
                        lowerBound = midPoint;
                        continue;
                    }
                    upperBound = midPoint;
                }
                return upperBound;
            }
        }
        return x;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/AbstractRealDistribution$Companion;", "", "()V", "SOLVER_DEFAULT_ABSOLUTE_ACCURACY", "", "getSOLVER_DEFAULT_ABSOLUTE_ACCURACY", "()D", "serialVersionUID", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public final double getSOLVER_DEFAULT_ABSOLUTE_ACCURACY() {
            return SOLVER_DEFAULT_ABSOLUTE_ACCURACY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

