/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.base.stat.Contour;
import jetbrains.datalore.plot.base.stat.ContourFillHelper;
import jetbrains.datalore.plot.base.stat.ContourStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J;\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u00140\u000fH\u0016J\u0012\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourfStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "binCount", "", "binWidth", "", "(ILjava/lang/Double;)V", "myBinOptions", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Ljetbrains/datalore/plot/base/Aes;", "Companion", "plot-base-portable"})
public final class ContourfStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BinStatUtil.BinOptions myBinOptions;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;

    public ContourfStat(int binCount, @Nullable Double binWidth) {
        super(DEF_MAPPING);
        this.myBinOptions = new BinStatUtil.BinOptions(binCount, binWidth);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getZ()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        Aes[] aesArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getZ()};
        if (!this.hasRequiredValues(data, aesArray)) {
            return this.withEmptyStatValues();
        }
        List<Double> list2 = ContourStatUtil.INSTANCE.computeLevels(data, this.myBinOptions);
        if (list2 == null) {
            return this.withEmptyStatValues();
        }
        List<Double> levels = list2;
        Map<Double, List<List<DoubleVector>>> pathListByLevel = ContourStatUtil.INSTANCE.computeContours$plot_base_portable(data, levels);
        DoubleSpan doubleSpan = data.range(TransformVar.INSTANCE.getX());
        Intrinsics.checkNotNull((Object)doubleSpan);
        DoubleSpan xRange = doubleSpan;
        DoubleSpan doubleSpan2 = data.range(TransformVar.INSTANCE.getY());
        Intrinsics.checkNotNull((Object)doubleSpan2);
        DoubleSpan yRange = doubleSpan2;
        DoubleSpan doubleSpan3 = data.range(TransformVar.INSTANCE.getZ());
        Intrinsics.checkNotNull((Object)doubleSpan3);
        DoubleSpan zRange = doubleSpan3;
        ContourFillHelper helper = new ContourFillHelper(xRange, yRange);
        List<Double> fillLevels = ContourFillHelper.Companion.computeFillLevels(zRange, levels);
        Map<Double, List<DoubleVector>> polygonListByFillLevel = helper.createPolygons(pathListByLevel, levels, fillLevels);
        return Contour.Companion.getPolygonDataFrame(fillLevels, polygonListByFillLevel);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/base/stat/ContourfStat$Companion;", "", "()V", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

