/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.BinStatUtil;
import jetbrains.datalore.plot.base.stat.DensityStat;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 32\u00020\u0001:\u00013BY\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J;\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2!\u0010&\u001a\u001d\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020+0\u001bH\u0016J\u0012\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030.0-H\u0016J\u0016\u0010/\u001a\u00020\u00032\u000e\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030-J\u0016\u00101\u001a\u00020\u00032\u000e\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030-R\u0014\u0010\u0007\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0019R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\f\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001f\u00a8\u00064"}, d2={"Ljetbrains/datalore/plot/base/stat/AbstractDensity2dStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "bandWidthX", "", "bandWidthY", "bandWidthMethod", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "adjust", "kernel", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "nX", "", "nY", "isContour", "", "binCount", "binWidth", "(Ljava/lang/Double;Ljava/lang/Double;Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;DLjetbrains/datalore/plot/base/stat/DensityStat$Kernel;IIZID)V", "getAdjust", "()D", "Ljava/lang/Double;", "binOptions", "Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "getBinOptions", "()Ljetbrains/datalore/plot/base/stat/BinStatUtil$BinOptions;", "()Z", "kernelFun", "Lkotlin/Function1;", "getKernelFun", "()Lkotlin/jvm/functions/Function1;", "getNX", "()I", "getNY", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Ljetbrains/datalore/plot/base/Aes;", "getBandWidthX", "xs", "getBandWidthY", "ys", "Companion", "plot-base-portable"})
public abstract class AbstractDensity2dStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Double bandWidthX;
    @Nullable
    private final Double bandWidthY;
    @NotNull
    private final DensityStat.BandWidthMethod bandWidthMethod;
    private final double adjust;
    @NotNull
    private final DensityStat.Kernel kernel;
    private final int nX;
    private final int nY;
    private final boolean isContour;
    private final int binCount;
    private final double binWidth;
    @NotNull
    private final Function1<Double, Double> kernelFun;
    @NotNull
    private final BinStatUtil.BinOptions binOptions;
    @NotNull
    private static final DensityStat.Kernel DEF_KERNEL = DensityStat.Kernel.GAUSSIAN;
    public static final double DEF_ADJUST = 1.0;
    public static final int DEF_N = 100;
    @NotNull
    private static final DensityStat.BandWidthMethod DEF_BW = DensityStat.BandWidthMethod.NRD0;
    public static final boolean DEF_CONTOUR = true;
    public static final int DEF_BIN_COUNT = 10;
    public static final double DEF_BIN_WIDTH = 0.0;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;
    private static final int MAX_N = 999;

    public AbstractDensity2dStat(@Nullable Double bandWidthX, @Nullable Double bandWidthY, @NotNull DensityStat.BandWidthMethod bandWidthMethod, double adjust, @NotNull DensityStat.Kernel kernel2, int nX, int nY, boolean isContour, int binCount, double binWidth) {
        Intrinsics.checkNotNullParameter((Object)((Object)bandWidthMethod), (String)"bandWidthMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        super(DEF_MAPPING);
        this.bandWidthX = bandWidthX;
        this.bandWidthY = bandWidthY;
        this.bandWidthMethod = bandWidthMethod;
        this.adjust = adjust;
        this.kernel = kernel2;
        this.nX = nX;
        this.nY = nY;
        this.isContour = isContour;
        this.binCount = binCount;
        this.binWidth = binWidth;
        this.kernelFun = DensityStatUtil.INSTANCE.kernel(this.kernel);
        this.binOptions = new BinStatUtil.BinOptions(this.binCount, this.binWidth);
        if (!(this.nX <= 999)) {
            boolean $i$a$-require-AbstractDensity2dStat$32 = false;
            String $i$a$-require-AbstractDensity2dStat$32 = "The input nX = " + this.nX + "  > 999 is too large!";
            throw new IllegalArgumentException($i$a$-require-AbstractDensity2dStat$32.toString());
        }
        if (!(this.nY <= 999)) {
            boolean bl = false;
            String string = "The input nY = " + this.nY + "  > 999 is too large!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    protected final double getAdjust() {
        return this.adjust;
    }

    protected final int getNX() {
        return this.nX;
    }

    protected final int getNY() {
        return this.nY;
    }

    protected final boolean isContour() {
        return this.isContour;
    }

    @NotNull
    protected final Function1<Double, Double> getKernelFun() {
        return this.kernelFun;
    }

    @NotNull
    protected final BinStatUtil.BinOptions getBinOptions() {
        return this.binOptions;
    }

    public final double getBandWidthX(@NotNull List<Double> xs) {
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Double d = this.bandWidthX;
        return d != null ? d.doubleValue() : DensityStatUtil.INSTANCE.bandWidth(this.bandWidthMethod, xs);
    }

    public final double getBandWidthY(@NotNull List<Double> ys) {
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        Double d = this.bandWidthY;
        return d != null ? d.doubleValue() : DensityStatUtil.INSTANCE.bandWidth(this.bandWidthMethod, ys);
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
        Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
        throw new IllegalStateException("'density2d' statistic can't be executed on the client side");
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getY())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ljetbrains/datalore/plot/base/stat/AbstractDensity2dStat$Companion;", "", "()V", "DEF_ADJUST", "", "DEF_BIN_COUNT", "", "DEF_BIN_WIDTH", "DEF_BW", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "getDEF_BW", "()Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "DEF_CONTOUR", "", "DEF_KERNEL", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "getDEF_KERNEL", "()Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_N", "MAX_N", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DensityStat.Kernel getDEF_KERNEL() {
            return DEF_KERNEL;
        }

        @NotNull
        public final DensityStat.BandWidthMethod getDEF_BW() {
            return DEF_BW;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

