/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.pos;

import java.util.HashMap;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.pos.PositionAdjustments;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/base/pos/BaseDodgePos;", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "myGroupCount", "", "mySize", "", "myIsHorizontalPos", "", "(Ljetbrains/datalore/plot/base/Aesthetics;ILjava/lang/Double;Z)V", "myDodgingNeeded", "Ljava/lang/Double;", "handlesGroups", "isDodgingNeeded", "translate", "Ljetbrains/datalore/base/geometry/DoubleVector;", "v", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "plot-base-portable"})
public abstract class BaseDodgePos
implements PositionAdjustment {
    private final int myGroupCount;
    @Nullable
    private final Double mySize;
    private final boolean myIsHorizontalPos;
    private final boolean myDodgingNeeded;

    public BaseDodgePos(@NotNull Aesthetics aesthetics, int myGroupCount, @Nullable Double mySize, boolean myIsHorizontalPos) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        this.myGroupCount = myGroupCount;
        this.mySize = mySize;
        this.myIsHorizontalPos = myIsHorizontalPos;
        this.myDodgingNeeded = this.isDodgingNeeded(aesthetics);
    }

    private final boolean isDodgingNeeded(Aesthetics aesthetics) {
        HashMap groupBy = new HashMap();
        Aes<Double> aes = this.myIsHorizontalPos ? Aes.Companion.getX() : Aes.Companion.getY();
        int n = aesthetics.dataPointCount();
        for (int i = 0; i < n; ++i) {
            DataPointAesthetics p = aesthetics.dataPointAt(i);
            if (!p.defined(aes)) continue;
            Double d = p.get(aes);
            Intrinsics.checkNotNull((Object)d);
            double value = ((Number)d).doubleValue();
            Integer group = p.group();
            if (groupBy.containsKey(value)) {
                if (Intrinsics.areEqual(groupBy.get(value), (Object)group)) continue;
                return true;
            }
            Double d2 = value;
            ((Map)groupBy).put(d2, group);
        }
        return false;
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx) {
        DoubleVector doubleVector;
        Double size;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (!this.myDodgingNeeded) {
            return v;
        }
        Aes<Double> aes = this.myIsHorizontalPos ? Aes.Companion.getX() : Aes.Companion.getY();
        double dataResolution = ctx.getResolution(aes);
        Double d = this.mySize;
        if (d == null) {
            d = this.myIsHorizontalPos ? p.width() : p.height();
        }
        if (!SeriesUtil.INSTANCE.isFinite(size = d)) {
            return v;
        }
        Integer n = p.group();
        Intrinsics.checkNotNull((Object)n);
        int slotIndex = n;
        double median = (double)(this.myGroupCount - 1) / 2.0;
        double d2 = ((double)slotIndex - median) * dataResolution;
        Double d3 = size;
        Intrinsics.checkNotNull((Object)d3);
        double offset = d2 * d3;
        Double d4 = p.get(aes);
        Intrinsics.checkNotNull((Object)d4);
        double center = ((Number)d4).doubleValue();
        double scaler = 1.0 / (double)this.myGroupCount;
        if (this.myIsHorizontalPos) {
            double newX = (v.getX() + offset - center) * scaler + center;
            doubleVector = new DoubleVector(newX, v.getY());
        } else {
            double newY = (v.getY() + offset - center) * scaler + center;
            doubleVector = new DoubleVector(v.getX(), newY);
        }
        return doubleVector;
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.DODGE.handlesGroups();
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }
}

