/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.data.GroupUtil;
import jetbrains.datalore.plot.builder.sampling.GroupAwareSampling;
import jetbrains.datalore.plot.builder.sampling.method.SamplingBase;
import jetbrains.datalore.plot.builder.sampling.method.SamplingUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b \u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fJ$\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fH\u0016J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/GroupSamplingBase;", "Ljetbrains/datalore/plot/builder/sampling/method/SamplingBase;", "Ljetbrains/datalore/plot/builder/sampling/GroupAwareSampling;", "sampleSize", "", "(I)V", "doSelect", "Ljetbrains/datalore/plot/base/DataFrame;", "population", "pickedGroups", "", "groupMapper", "Lkotlin/Function1;", "isApplicable", "", "groupCount", "plot-builder-portable"})
public abstract class GroupSamplingBase
extends SamplingBase
implements GroupAwareSampling {
    public GroupSamplingBase(int sampleSize) {
        super(sampleSize);
    }

    @Override
    public boolean isApplicable(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        return this.isApplicable(population, groupMapper2, SamplingUtil.INSTANCE.groupCount(groupMapper2, population.rowCount()));
    }

    public boolean isApplicable(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2, int groupCount2) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        return groupCount2 > this.getSampleSize();
    }

    @NotNull
    public final DataFrame doSelect(@NotNull DataFrame population, @NotNull Set<Integer> pickedGroups, @NotNull Function1<? super Integer, Integer> groupMapper2) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(pickedGroups, (String)"pickedGroups");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        Map<Integer, List<Integer>> indicesByGroup = GroupUtil.INSTANCE.indicesByGroup(population.rowCount(), groupMapper2);
        ArrayList pickedIndices = new ArrayList();
        Iterator<Integer> iterator = pickedGroups.iterator();
        while (iterator.hasNext()) {
            int group = ((Number)iterator.next()).intValue();
            List<Integer> list = indicesByGroup.get(group);
            Intrinsics.checkNotNull(list);
            pickedIndices.addAll(list);
        }
        return population.selectIndices((List)pickedIndices);
    }
}

