/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.LegendArrangement;
import jetbrains.datalore.plot.builder.guide.LegendJustification;
import jetbrains.datalore.plot.builder.guide.LegendPosition;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.LegendBoxesLayout;
import jetbrains.datalore.plot.builder.layout.LegendsBlockInfo;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayoutUtil;", "", "()V", "arrangeLegendBoxes", "Ljetbrains/datalore/plot/builder/layout/LegendsBlockInfo;", "infos", "", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "horizontalStack", "Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayout$BoxWithLocation;", "boxInfos", "overlayLegendOrigin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plotBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "legendSize", "legendPosition", "Ljetbrains/datalore/plot/builder/guide/LegendPosition;", "legendJustification", "Ljetbrains/datalore/plot/builder/guide/LegendJustification;", "verticalStack", "plot-builder-portable"})
public final class LegendBoxesLayoutUtil {
    @NotNull
    public static final LegendBoxesLayoutUtil INSTANCE = new LegendBoxesLayoutUtil();

    private LegendBoxesLayoutUtil() {
    }

    @NotNull
    public final LegendsBlockInfo arrangeLegendBoxes(@NotNull List<? extends LegendBoxInfo> infos, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        LegendArrangement legendArrangement = LegendArrangement.VERTICAL;
        List<LegendBoxesLayout.BoxWithLocation> boxWithLocationList = WhenMappings.$EnumSwitchMapping$0[legendArrangement.ordinal()] == 1 ? this.verticalStack(infos) : this.horizontalStack(infos);
        return new LegendsBlockInfo(boxWithLocationList);
    }

    private final List<LegendBoxesLayout.BoxWithLocation> verticalStack(List<? extends LegendBoxInfo> boxInfos) {
        ArrayList<LegendBoxesLayout.BoxWithLocation> result2 = new ArrayList<LegendBoxesLayout.BoxWithLocation>();
        double y2 = 0.0;
        for (LegendBoxInfo legendBoxInfo : boxInfos) {
            result2.add(new LegendBoxesLayout.BoxWithLocation(legendBoxInfo, new DoubleVector(0.0, y2)));
            y2 += legendBoxInfo.getSize$plot_builder_portable().getY();
        }
        return result2;
    }

    private final List<LegendBoxesLayout.BoxWithLocation> horizontalStack(List<? extends LegendBoxInfo> boxInfos) {
        ArrayList<LegendBoxesLayout.BoxWithLocation> result2 = new ArrayList<LegendBoxesLayout.BoxWithLocation>();
        double x2 = 0.0;
        for (LegendBoxInfo legendBoxInfo : boxInfos) {
            result2.add(new LegendBoxesLayout.BoxWithLocation(legendBoxInfo, new DoubleVector(x2, 0.0)));
            x2 += legendBoxInfo.getSize$plot_builder_portable().getX();
        }
        return result2;
    }

    @NotNull
    public final DoubleVector overlayLegendOrigin(@NotNull DoubleRectangle plotBounds, @NotNull DoubleVector legendSize, @NotNull LegendPosition legendPosition, @NotNull LegendJustification legendJustification) {
        Intrinsics.checkNotNullParameter((Object)plotBounds, (String)"plotBounds");
        Intrinsics.checkNotNullParameter((Object)legendSize, (String)"legendSize");
        Intrinsics.checkNotNullParameter((Object)legendPosition, (String)"legendPosition");
        Intrinsics.checkNotNullParameter((Object)legendJustification, (String)"legendJustification");
        DoubleVector plotSize2 = plotBounds.getDimension();
        DoubleVector absolutePosition = new DoubleVector(plotBounds.getLeft() + plotSize2.getX() * legendPosition.getX(), plotBounds.getBottom() - plotSize2.getY() * legendPosition.getY());
        DoubleVector originOffset = new DoubleVector(-legendSize.getX() * legendJustification.getX(), legendSize.getY() * legendJustification.getY() - legendSize.getY());
        return absolutePosition.add(originOffset);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LegendArrangement.values().length];
            try {
                nArray[LegendArrangement.VERTICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

