/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.interact.loc;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleRectangles;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.plot.base.interact.GeomTargetLocator;
import jetbrains.datalore.plot.builder.interact.MathUtil;
import jetbrains.datalore.plot.builder.interact.loc.PolygonTargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.TargetProjection;
import jetbrains.datalore.plot.builder.interact.loc.TargetProjectionKt;
import jetbrains.datalore.plot.common.geometry.PolylineSimplifier;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0006\u0010\f\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection;", "Ljetbrains/datalore/plot/builder/interact/loc/TargetProjection;", "data", "", "(Ljava/lang/Object;)V", "getData", "()Ljava/lang/Object;", "x", "Ljetbrains/datalore/base/interval/DoubleSpan;", "xy", "", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection$RingXY;", "y", "Companion", "RingXY", "plot-builder-portable"})
public final class PolygonTargetProjection
extends TargetProjection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object data;
    private static final double POINTS_COUNT_TO_SKIP_SIMPLIFICATION = 20.0;
    private static final double AREA_TOLERANCE_RATIO = 0.1;
    private static final double MAX_TOLERANCE = 40.0;
    private static final boolean isLogEnabled = false;

    private PolygonTargetProjection(Object data) {
        this.data = data;
    }

    @NotNull
    public final Object getData() {
        return this.data;
    }

    @NotNull
    public final DoubleSpan x() {
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type jetbrains.datalore.base.interval.DoubleSpan");
        return (DoubleSpan)object;
    }

    @NotNull
    public final DoubleSpan y() {
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type jetbrains.datalore.base.interval.DoubleSpan");
        return (DoubleSpan)object;
    }

    @NotNull
    public final List<RingXY> xy() {
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<jetbrains.datalore.plot.builder.interact.loc.PolygonTargetProjection.RingXY>");
        return (List)object;
    }

    public /* synthetic */ PolygonTargetProjection(Object data, DefaultConstructorMarker $constructor_marker) {
        this(data);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\u0018H\u0002J\"\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\f2\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection$Companion;", "", "()V", "AREA_TOLERANCE_RATIO", "", "MAX_TOLERANCE", "POINTS_COUNT_TO_SKIP_SIMPLIFICATION", "isLogEnabled", "", "create", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection;", "points", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "lookupSpace", "Ljetbrains/datalore/plot/base/interact/GeomTargetLocator$LookupSpace;", "log", "", "str", "", "mapToCoord", "Ljetbrains/datalore/base/interval/DoubleSpan;", "rings", "coord", "Lkotlin/Function1;", "mapToXY", "Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection$RingXY;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PolygonTargetProjection create(@NotNull List<DoubleVector> points, @NotNull GeomTargetLocator.LookupSpace lookupSpace) {
            PolygonTargetProjection polygonTargetProjection;
            Intrinsics.checkNotNullParameter(points, (String)"points");
            Intrinsics.checkNotNullParameter((Object)((Object)lookupSpace), (String)"lookupSpace");
            List<List<DoubleVector>> rings = GeometryKt.splitRings(points);
            switch (WhenMappings.$EnumSwitchMapping$0[lookupSpace.ordinal()]) {
                case 1: {
                    polygonTargetProjection = new PolygonTargetProjection(this.mapToCoord(rings, (Function1<? super DoubleVector, Double>)((Function1)create.1.INSTANCE)), null);
                    break;
                }
                case 2: {
                    polygonTargetProjection = new PolygonTargetProjection(this.mapToCoord(rings, (Function1<? super DoubleVector, Double>)((Function1)create.2.INSTANCE)), null);
                    break;
                }
                case 3: {
                    polygonTargetProjection = new PolygonTargetProjection(this.mapToXY(rings), null);
                    break;
                }
                case 4: {
                    TargetProjectionKt.access$undefinedLookupSpaceError();
                    throw new KotlinNothingValueException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return polygonTargetProjection;
        }

        private final DoubleSpan mapToCoord(List<? extends List<DoubleVector>> rings, Function1<? super DoubleVector, Double> coord) {
            double min;
            double max = min = ((Number)coord.invoke((Object)rings.get(0).get(0))).doubleValue();
            for (List<DoubleVector> list2 : rings) {
                for (DoubleVector point2 : list2) {
                    min = Math.min(min, ((Number)coord.invoke((Object)point2)).doubleValue());
                    max = Math.max(max, ((Number)coord.invoke((Object)point2)).doubleValue());
                }
            }
            return new DoubleSpan(min, max);
        }

        private final List<RingXY> mapToXY(List<? extends List<DoubleVector>> rings) {
            ArrayList<RingXY> polygon2 = new ArrayList<RingXY>();
            for (List<DoubleVector> list2 : rings) {
                DoubleRectangle bbox2;
                if (list2.size() < 4) continue;
                if (DoubleRectangles.INSTANCE.boundingBox((Iterable<DoubleVector>)list2) == null) {
                    throw new IllegalStateException("bbox should be not null - ring is not empty".toString());
                }
                double area2 = GeometryKt.calculateArea(list2);
                List<DoubleVector> simplifiedRing = null;
                if ((double)list2.size() > 20.0) {
                    double tolerance = Math.min(area2 * 0.1, 40.0);
                    simplifiedRing = PolylineSimplifier.Companion.visvalingamWhyatt(list2).setWeightLimit(tolerance).getPoints();
                } else {
                    simplifiedRing = list2;
                }
                if (simplifiedRing.size() < 4) continue;
                polygon2.add(new RingXY(simplifiedRing, bbox2));
            }
            return polygon2;
        }

        private final void log(String str) {
            System.out.println((Object)str);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GeomTargetLocator.LookupSpace.values().length];
                try {
                    nArray[GeomTargetLocator.LookupSpace.X.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeomTargetLocator.LookupSpace.Y.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeomTargetLocator.LookupSpace.XY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GeomTargetLocator.LookupSpace.NONE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/builder/interact/loc/PolygonTargetProjection$RingXY;", "", "edges", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "bbox", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "(Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleRectangle;)V", "contains", "", "p", "plot-builder-portable"})
    public static final class RingXY {
        @NotNull
        private final List<DoubleVector> edges;
        @NotNull
        private final DoubleRectangle bbox;

        public RingXY(@NotNull List<DoubleVector> edges, @NotNull DoubleRectangle bbox2) {
            Intrinsics.checkNotNullParameter(edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)bbox2, (String)"bbox");
            this.edges = edges;
            this.bbox = bbox2;
        }

        public final boolean contains(@NotNull DoubleVector p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            return this.bbox.contains(p) && MathUtil.INSTANCE.polygonContainsCoordinate$plot_builder_portable(this.edges, p);
        }
    }
}

