/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.Iterator;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.render.svg.GroupComponent;
import jetbrains.datalore.plot.base.render.svg.MultilineLabel;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.Text;
import jetbrains.datalore.plot.builder.guide.LegendBox;
import jetbrains.datalore.plot.builder.guide.LegendBreak;
import jetbrains.datalore.plot.builder.guide.LegendComponentLayout;
import jetbrains.datalore.plot.builder.guide.LegendComponentSpec;
import jetbrains.datalore.plot.builder.layout.PlotLabelSpecFactory;
import jetbrains.datalore.vis.svg.SvgElement;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import jetbrains.datalore.vis.svg.SvgTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendComponent;", "Ljetbrains/datalore/plot/builder/guide/LegendBox;", "spec", "Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;", "(Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;)V", "getSpec", "()Ljetbrains/datalore/plot/builder/guide/LegendComponentSpec;", "appendGuideContent", "Ljetbrains/datalore/base/geometry/DoubleVector;", "contentRoot", "Ljetbrains/datalore/vis/svg/SvgNode;", "createBreakElement", "Ljetbrains/datalore/vis/svg/SvgElement;", "br", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "keySize", "keyLabelBox", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelBox", "createKeyElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "legendBreak", "size", "plot-builder-portable"})
public final class LegendComponent
extends LegendBox {
    @NotNull
    private final LegendComponentSpec spec;

    public LegendComponent(@NotNull LegendComponentSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = spec;
    }

    @Override
    @NotNull
    public LegendComponentSpec getSpec() {
        return this.spec;
    }

    @Override
    @NotNull
    protected DoubleVector appendGuideContent(@NotNull SvgNode contentRoot) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        LegendComponentLayout layout = this.getSpec().getLayout();
        Iterator<DoubleRectangle> keyLabelBoxes = layout.getKeyLabelBoxes().iterator();
        Iterator<DoubleRectangle> labelBoxes = layout.getLabelBoxes().iterator();
        Iterator<DoubleVector> keySizes = layout.getKeySizes().iterator();
        for (LegendBreak br : this.getSpec().getBreaks$plot_builder_portable()) {
            DoubleRectangle keyLabelBox = keyLabelBoxes.next();
            DoubleRectangle labelBox = labelBoxes.next();
            DoubleVector keySize = keySizes.next();
            SvgElement breakElement = this.createBreakElement(br, keySize, keyLabelBox, labelBox);
            contentRoot.children().add(breakElement);
        }
        if (this.getDebug()) {
            DoubleRectangle graphBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), layout.getGraphSize());
            contentRoot.children().add(LegendBox.Companion.createTransparentRect(graphBounds, Color.Companion.getDARK_BLUE(), 1.0));
        }
        return layout.getSize();
    }

    private final SvgElement createBreakElement(LegendBreak br, DoubleVector keySize, DoubleRectangle keyLabelBox, DoubleRectangle labelBox) {
        GroupComponent breakComponent = new GroupComponent();
        breakComponent.add(this.createKeyElement(br, keySize));
        MultilineLabel label = new MultilineLabel(br.getLabel());
        double lineHeight = PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).height();
        label.addClassName("legend-item");
        label.setHorizontalAnchor(Text.HorizontalAnchor.LEFT);
        label.setLineHeight(lineHeight);
        label.moveTo(labelBox.getOrigin().add(new DoubleVector(0.0, lineHeight * 0.35)));
        breakComponent.add(label);
        breakComponent.moveTo(keyLabelBox.getOrigin());
        return breakComponent.getRootGroup();
    }

    private final SvgGElement createKeyElement(LegendBreak legendBreak, DoubleVector size2) {
        SvgGElement g = new SvgGElement();
        DoubleRectangle keyBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), size2);
        SvgRectElement backgroundRect = new SvgRectElement(keyBounds);
        backgroundRect.strokeWidth().set(0.0);
        backgroundRect.fillColor().set(this.getTheme().backgroundFill());
        g.children().add(backgroundRect);
        DoubleVector innerSize = new DoubleVector(size2.getX() - (double)2, size2.getY() - (double)2);
        SvgGElement keyElement = legendBreak.createKeyElement(innerSize);
        SvgTransform keyElementTransform = SvgComponent.Companion.buildTransform(new DoubleVector(1.0, 1.0), 0.0);
        keyElement.transform().set(keyElementTransform);
        g.children().add(keyElement);
        SvgRectElement frame = LegendBox.Companion.createTransparentRect(keyBounds, this.getTheme().backgroundFill(), 1.0);
        g.children().add(frame);
        return g;
    }
}

