/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.AbstractUnivariateSolver;
import jetbrains.datalore.plot.base.stat.math3.Precision;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0014\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/BrentSolver;", "Ljetbrains/datalore/plot/base/stat/math3/AbstractUnivariateSolver;", "absoluteAccuracy", "", "(D)V", "relativeAccuracy", "(DD)V", "functionValueAccuracy", "(DDD)V", "brent", "lo", "hi", "fLo", "fHi", "doSolve", "Companion", "plot-base-portable"})
public final class BrentSolver
extends AbstractUnivariateSolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    @JvmOverloads
    public BrentSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public /* synthetic */ BrentSolver(double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = DEFAULT_ABSOLUTE_ACCURACY;
        }
        this(d);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
    }

    @Override
    protected double doSolve() {
        double min = this.getMin();
        double max = this.getMax();
        double initial = this.getStartValue();
        double functionValueAccuracy = this.getFunctionValueAccuracy();
        this.verifySequence(min, initial, max);
        double yInitial = this.computeObjectiveValue(initial);
        if (Math.abs(yInitial) <= functionValueAccuracy) {
            return initial;
        }
        double yMin = this.computeObjectiveValue(min);
        if (Math.abs(yMin) <= functionValueAccuracy) {
            return min;
        }
        if (yInitial * yMin < 0.0) {
            return this.brent(min, initial, yMin, yInitial);
        }
        double yMax = this.computeObjectiveValue(max);
        if (Math.abs(yMax) <= functionValueAccuracy) {
            return max;
        }
        if (yInitial * yMax < 0.0) {
            return this.brent(initial, max, yInitial, yMax);
        }
        throw new IllegalStateException(("NoBracketing - min: " + min + ", max: " + max + ", yMin: " + yMin + ", yMax: " + yMax).toString());
    }

    private final double brent(double lo, double hi, double fLo, double fHi) {
        double d;
        double a2 = lo;
        double fa = fLo;
        double b2 = hi;
        double fb = fHi;
        double c = a2;
        double fc = fa;
        double e = d = b2 - a2;
        double t = this.getAbsoluteAccuracy();
        double eps = this.getRelativeAccuracy();
        while (true) {
            if (Math.abs(fc) < Math.abs(fb)) {
                a2 = b2;
                b2 = c;
                c = a2;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol = 2.0 * eps * Math.abs(b2) + t;
            double m = 0.5 * (c - b2);
            if (Math.abs(m) <= tol || Precision.equals$default(Precision.INSTANCE, fb, 0.0, 0, 4, null)) {
                return b2;
            }
            if (Math.abs(e) < tol || Math.abs(fa) <= Math.abs(fb)) {
                e = d = m;
            } else {
                double s2 = fb / fa;
                double p = 0.0;
                double q = 0.0;
                if (a2 == c) {
                    p = 2.0 * m * s2;
                    q = 1.0 - s2;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s2 * (2.0 * m * q * (q - r) - (b2 - a2) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s2 - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                s2 = e;
                e = d;
                if (p >= 1.5 * m * q - Math.abs(tol * q) || p >= Math.abs(0.5 * s2 * q)) {
                    e = d = m;
                } else {
                    d = p / q;
                }
            }
            a2 = b2;
            fa = fb;
            b2 = Math.abs(d) > tol ? (b2 += d) : (m > 0.0 ? (b2 += tol) : (b2 -= tol));
            fb = this.computeObjectiveValue(b2);
            if (!(fb > 0.0 && fc > 0.0) && (!(fb <= 0.0) || !(fc <= 0.0))) continue;
            c = a2;
            fc = fa;
            e = d = b2 - a2;
        }
    }

    @JvmOverloads
    public BrentSolver() {
        this(0.0, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/BrentSolver$Companion;", "", "()V", "DEFAULT_ABSOLUTE_ACCURACY", "", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

