/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.interval.DoubleSpan;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.AreaRidgesGeom;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.WithHeight;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.LinesHelper;
import jetbrains.datalore.plot.base.geom.util.MultiPointData;
import jetbrains.datalore.plot.base.geom.util.MultiPointDataConstructor;
import jetbrains.datalore.plot.base.geom.util.QuantilesHelper;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.svg.LinePath;
import jetbrains.datalore.plot.base.stat.DensityRidgesStat;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.SvgLineElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\u0005\u00a2\u0006\u0002\u0010\u0003JI\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2!\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020'0#H\u0002J0\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J0\u00101\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J6\u00102\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u00105\u001a\u0002062\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J0\u00107\u001a\u0004\u0018\u0001082\u0006\u0010&\u001a\u00020\u001d2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050:2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020\u000bH\u0016J\"\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J+\u0010>\u001a\u001d\u0012\u0013\u0012\u00110\u001d\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020'0#2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0007\"\u0004\b\u0018\u0010\t\u00a8\u0006@"}, d2={"Ljetbrains/datalore/plot/base/geom/AreaRidgesGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "Ljetbrains/datalore/plot/base/geom/WithHeight;", "()V", "minHeight", "", "getMinHeight", "()D", "setMinHeight", "(D)V", "quantileLines", "", "getQuantileLines", "()Z", "setQuantileLines", "(Z)V", "quantiles", "", "getQuantiles", "()Ljava/util/List;", "setQuantiles", "(Ljava/util/List;)V", "scale", "getScale", "setScale", "buildHints", "", "dataPoints", "", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "helper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "boundTransform", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "p", "Ljetbrains/datalore/base/geometry/DoubleVector;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "buildLines", "buildRidge", "createQuantileLines", "Ljetbrains/datalore/vis/svg/SvgLineElement;", "quantilesHelper", "Ljetbrains/datalore/plot/base/geom/util/QuantilesHelper;", "heightSpan", "Ljetbrains/datalore/base/interval/DoubleSpan;", "coordAes", "Ljetbrains/datalore/plot/base/Aes;", "resolution", "isDiscrete", "splitDataPointsByMinHeight", "toLocationBound", "Companion", "plot-base-portable"})
public final class AreaRidgesGeom
extends GeomBase
implements WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double scale = 1.0;
    private double minHeight;
    @NotNull
    private List<Double> quantiles = DensityRidgesStat.Companion.getDEF_QUANTILES();
    private boolean quantileLines;
    public static final double DEF_SCALE = 1.0;
    public static final double DEF_MIN_HEIGHT = 0.0;
    public static final boolean DEF_QUANTILE_LINES = false;
    public static final boolean HANDLES_GROUPS = true;

    public final double getScale() {
        return this.scale;
    }

    public final void setScale(double d) {
        this.scale = d;
    }

    public final double getMinHeight() {
        return this.minHeight;
    }

    public final void setMinHeight(double d) {
        this.minHeight = d;
    }

    @NotNull
    public final List<Double> getQuantiles() {
        return this.quantiles;
    }

    public final void setQuantiles(@NotNull List<Double> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.quantiles = list2;
    }

    public final boolean getQuantileLines() {
        return this.quantileLines;
    }

    public final void setQuantileLines(boolean bl) {
        this.quantileLines = bl;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.buildLines(root, aesthetics, pos, coord, ctx2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildLines(SvgRoot root, Aesthetics aesthetics, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object list$iv$iv;
        boolean bl;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Iterable $this$sortedByDescending$iv;
        Iterable<DataPointAesthetics> definedDataPoints = GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getHEIGHT());
        if (!CollectionsKt.any(definedDataPoints)) {
            return;
        }
        Iterable<DataPointAesthetics> iterable = definedDataPoints;
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                DataPointAesthetics p0 = (DataPointAesthetics)b2;
                boolean bl = false;
                Comparable comparable = p0.y();
                p0 = (DataPointAesthetics)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)p0.y());
            }
        });
        boolean $i$f$groupBy = false;
        Iterator iterator2 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            DataPointAesthetics p0 = (DataPointAesthetics)t;
            bl = false;
            Double key$iv$iv = p0.y();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            list$iv$iv = entry;
            Object object = destination$iv$iv;
            bl = false;
            Double y2 = (Double)list$iv$iv.getKey();
            List nonOrderedPoints = (List)list$iv$iv.getValue();
            object.add(TuplesKt.to((Object)y2, GeomUtil.INSTANCE.ordered_X(nonOrderedPoints)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair2 = (Pair)element$iv;
            boolean bl2 = false;
            Iterable iterable2 = (Iterable)pair2.component2();
            Iterable $this$forEach$iv2 = this.splitDataPointsByMinHeight(iterable2);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Iterable it = (Iterable)element$iv2;
                boolean bl3 = false;
                this.buildRidge(root, it, pos, coord, ctx2);
            }
        }
    }

    private final List<Iterable<DataPointAesthetics>> splitDataPointsByMinHeight(Iterable<? extends DataPointAesthetics> dataPoints2) {
        List result2 = new ArrayList();
        List dataPointsBunch = new ArrayList();
        for (DataPointAesthetics dataPointAesthetics : dataPoints2) {
            Double d = dataPointAesthetics.height();
            Intrinsics.checkNotNull((Object)d);
            if (d >= this.minHeight) {
                dataPointsBunch.add(dataPointAesthetics);
                continue;
            }
            if (CollectionsKt.any((Iterable)dataPointsBunch)) {
                result2.add(dataPointsBunch);
            }
            dataPointsBunch = new ArrayList();
        }
        if (CollectionsKt.any((Iterable)dataPointsBunch)) {
            result2.add(dataPointsBunch);
        }
        return result2;
    }

    private final void buildRidge(SvgRoot root, Iterable<? extends DataPointAesthetics> dataPoints2, PositionAdjustment pos, CoordinateSystem coord, GeomContext ctx2) {
        LinesHelper helper = new LinesHelper(pos, coord, ctx2);
        QuantilesHelper quantilesHelper = new QuantilesHelper(pos, coord, ctx2, this.quantiles, Aes.Companion.getY());
        Function1<DataPointAesthetics, DoubleVector> boundTransform = this.toLocationBound(ctx2);
        Iterable $this$forEach$iv = quantilesHelper.splitByQuantiles$plot_base_portable(dataPoints2, Aes.Companion.getX());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List points = (List)element$iv;
            boolean bl = false;
            List<LinePath> paths2 = helper.createBands(points, boundTransform, (Function1<? super DataPointAesthetics, DoubleVector>)((Function1)buildRidge.1.paths.1.INSTANCE), true);
            GeomBase.Companion.appendNodes(paths2, root);
            helper.setAlphaEnabled(false);
            GeomBase.Companion.appendNodes(helper.createLines(points, boundTransform), root);
            this.buildHints(points, ctx2, helper, boundTransform);
        }
        if (this.quantileLines) {
            $this$forEach$iv = this.createQuantileLines(dataPoints2, quantilesHelper, ctx2);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgLineElement quantileLine = (SvgLineElement)element$iv;
                boolean bl = false;
                root.add(quantileLine);
            }
        }
    }

    private final List<SvgLineElement> createQuantileLines(Iterable<? extends DataPointAesthetics> dataPoints2, QuantilesHelper quantilesHelper, GeomContext ctx2) {
        Function1<DataPointAesthetics, DoubleVector> toLocationBoundStart2 = this.toLocationBound(ctx2);
        Function1 toLocationBoundEnd2 = createQuantileLines.toLocationBoundEnd.1.INSTANCE;
        return quantilesHelper.getQuantileLineElements$plot_base_portable(dataPoints2, Aes.Companion.getX(), toLocationBoundStart2, (Function1<? super DataPointAesthetics, DoubleVector>)toLocationBoundEnd2);
    }

    private final Function1<DataPointAesthetics, DoubleVector> toLocationBound(GeomContext ctx2) {
        return (Function1)new Function1<DataPointAesthetics, DoubleVector>(ctx2, this){
            final /* synthetic */ GeomContext $ctx;
            final /* synthetic */ AreaRidgesGeom this$0;
            {
                this.$ctx = $ctx;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Double d = p.x();
                Intrinsics.checkNotNull((Object)d);
                double x2 = d;
                Double d2 = p.y();
                Intrinsics.checkNotNull((Object)d2);
                double d3 = d2;
                double d4 = this.$ctx.getResolution(Aes.Companion.getY()) * this.this$0.getScale();
                Double d5 = p.height();
                Intrinsics.checkNotNull((Object)d5);
                double y2 = d3 + d4 * d5;
                return new DoubleVector(x2, y2);
            }
        };
    }

    private final void buildHints(Iterable<? extends DataPointAesthetics> dataPoints2, GeomContext ctx2, GeomHelper helper, Function1<? super DataPointAesthetics, DoubleVector> boundTransform) {
        List<MultiPointData> multiPointDataList2 = MultiPointDataConstructor.INSTANCE.createMultiPointDataByGroup(dataPoints2, MultiPointDataConstructor.INSTANCE.singlePointAppender((Function1<? super DataPointAesthetics, DoubleVector>)((Function1)new Function1<DataPointAesthetics, DoubleVector>(boundTransform, helper){
            final /* synthetic */ Function1<DataPointAesthetics, DoubleVector> $boundTransform;
            final /* synthetic */ GeomHelper $helper;
            {
                this.$boundTransform = $boundTransform;
                this.$helper = $helper;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Object object = this.$boundTransform.invoke((Object)p);
                GeomHelper geomHelper = this.$helper;
                DoubleVector it = (DoubleVector)object;
                boolean bl = false;
                return geomHelper.toClient(it, p);
            }
        })), MultiPointDataConstructor.INSTANCE.reducer(0.999, false));
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        Function1<DataPointAesthetics, List<Color>> colorMarkerMapper = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.AREA_RIDGES, ctx2);
        for (MultiPointData multiPointData : multiPointDataList2) {
            targetCollector.addPath(multiPointData.getPoints(), multiPointData.getLocalToGlobalIndex(), new GeomTargetCollector.TooltipParams(null, null, null, (List)colorMarkerMapper.invoke((Object)multiPointData.getAes()), 7, null), ctx2.getFlipped() ? TipLayoutHint.Kind.VERTICAL_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
        }
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        Aes<Double> sizeAes = Aes.Companion.getHEIGHT();
        double scaledResolution = resolution * this.scale;
        Double loc = p.get(coordAes);
        Double size2 = p.get(sizeAes);
        if (SeriesUtil.INSTANCE.allFinite(loc, size2)) {
            Intrinsics.checkNotNull((Object)loc);
            Double d = size2;
            Intrinsics.checkNotNull((Object)d);
            double expand = scaledResolution * d;
            doubleSpan = size2 >= this.minHeight ? new DoubleSpan(loc, loc + expand) : null;
        } else {
            doubleSpan = null;
        }
        return doubleSpan;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/AreaRidgesGeom$Companion;", "", "()V", "DEF_MIN_HEIGHT", "", "DEF_QUANTILE_LINES", "", "DEF_SCALE", "HANDLES_GROUPS", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

