/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.mapper.core;

import java.util.Iterator;
import jetbrains.datalore.mapper.core.Mapper;
import jetbrains.datalore.mapper.core.MapperFactory;
import jetbrains.datalore.mapper.core.MapperProcessor;
import jetbrains.datalore.mapper.core.RoleSynchronizer;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007H\u0016J\u001c\u0010\u0010\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007H\u0016JQ\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00070\u00062\u001a\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0018\u00010\u00062\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0007H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001c\u0010\u0013\u001a\u00020\u000e2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0016J%\u0010\u0015\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u00162\u0006\u0010\u0017\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0018JC\u0010\u0015\u001a\u0014\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u0001\u0018\u00010\u00162\u001a\u0010\u0011\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0018\u00010\u00062\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019J\u001e\u0010\u001a\u001a\u00020\u000e2\u0016\u0010\u001b\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010\u0016R$\u0010\u0005\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR$\u0010\t\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR$\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/mapper/core/BaseRoleSynchronizer;", "SourceT", "TargetT", "Ljetbrains/datalore/mapper/core/RoleSynchronizer;", "()V", "myErrorMapperFactories", "", "Ljetbrains/datalore/mapper/core/MapperFactory;", "[Ljetbrains/datalore/mapper/core/MapperFactory;", "myMapperFactories", "myMapperProcessors", "Ljetbrains/datalore/mapper/core/MapperProcessor;", "[Ljetbrains/datalore/mapper/core/MapperProcessor;", "addErrorMapperFactory", "", "factory", "addMapperFactory", "mapperFactories", "([Ljetbrains/datalore/mapper/core/MapperFactory;Ljetbrains/datalore/mapper/core/MapperFactory;)[Ljetbrains/datalore/mapper/core/MapperFactory;", "addMapperProcessor", "processor", "createMapper", "Ljetbrains/datalore/mapper/core/Mapper;", "source", "(Ljava/lang/Object;)Ljetbrains/datalore/mapper/core/Mapper;", "([Ljetbrains/datalore/mapper/core/MapperFactory;Ljava/lang/Object;)Ljetbrains/datalore/mapper/core/Mapper;", "processMapper", "mapper", "mapper-core"})
public abstract class BaseRoleSynchronizer<SourceT, TargetT>
implements RoleSynchronizer<SourceT, TargetT> {
    @Nullable
    private MapperFactory<SourceT, TargetT>[] myMapperFactories;
    @Nullable
    private MapperFactory<SourceT, TargetT>[] myErrorMapperFactories;
    @Nullable
    private MapperProcessor<SourceT, TargetT>[] myMapperProcessors;

    private final MapperFactory<SourceT, TargetT>[] addMapperFactory(MapperFactory<SourceT, TargetT>[] mapperFactories, MapperFactory<SourceT, TargetT> factory) {
        MapperFactory[] mapperFactoryArray;
        if (factory == null) {
            throw new NullPointerException("mapper factory is null");
        }
        if (mapperFactories == null) {
            MapperFactory[] mapperFactoryArray2 = new MapperFactory[]{factory};
            mapperFactoryArray = mapperFactoryArray2;
        } else {
            int n = mapperFactories.length + 1;
            MapperFactory[] mapperFactoryArray3 = new MapperFactory[n];
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                mapperFactoryArray3[n2] = n2 < mapperFactories.length ? mapperFactories[n2] : factory;
            }
            mapperFactoryArray = mapperFactoryArray3;
        }
        return mapperFactoryArray;
    }

    @Override
    public void addMapperFactory(@NotNull MapperFactory<SourceT, TargetT> factory) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.myMapperFactories = this.addMapperFactory(this.myMapperFactories, factory);
    }

    @Override
    public void addErrorMapperFactory(@NotNull MapperFactory<SourceT, TargetT> factory) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.myErrorMapperFactories = this.addMapperFactory(this.myErrorMapperFactories, factory);
    }

    @Override
    public void addMapperProcessor(@NotNull MapperProcessor<SourceT, TargetT> processor) {
        MapperProcessor[] mapperProcessorArray;
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        BaseRoleSynchronizer baseRoleSynchronizer = this;
        if (this.myMapperProcessors == null) {
            MapperProcessor[] mapperProcessorArray2 = new MapperProcessor[]{processor};
            mapperProcessorArray = mapperProcessorArray2;
        } else {
            Intrinsics.checkNotNull(this.myMapperProcessors);
            int n = this.myMapperProcessors.length + 1;
            MapperProcessor[] mapperProcessorArray3 = new MapperProcessor[n];
            BaseRoleSynchronizer baseRoleSynchronizer2 = baseRoleSynchronizer;
            for (int i = 0; i < n; ++i) {
                MapperProcessor<SourceT, TargetT> mapperProcessor;
                int n2 = i;
                Intrinsics.checkNotNull(this.myMapperProcessors);
                if (n2 < this.myMapperProcessors.length) {
                    Intrinsics.checkNotNull(this.myMapperProcessors);
                    mapperProcessor = this.myMapperProcessors[n2];
                } else {
                    mapperProcessor = processor;
                }
                mapperProcessorArray3[n2] = mapperProcessor;
            }
            baseRoleSynchronizer = baseRoleSynchronizer2;
            mapperProcessorArray = mapperProcessorArray3;
        }
        baseRoleSynchronizer.myMapperProcessors = mapperProcessorArray;
    }

    private final Mapper<? extends SourceT, ? extends TargetT> createMapper(MapperFactory<SourceT, TargetT>[] mapperFactories, SourceT source) {
        Iterator iterator2;
        Mapper result2 = null;
        if (mapperFactories != null && (iterator2 = ArrayIteratorKt.iterator((Object[])mapperFactories)).hasNext()) {
            MapperFactory f = (MapperFactory)iterator2.next();
            result2 = f.createMapper(source);
        }
        return result2;
    }

    @NotNull
    protected final Mapper<? extends SourceT, ? extends TargetT> createMapper(SourceT source) {
        Mapper<SourceT, TargetT> result2 = this.createMapper(this.myMapperFactories, source);
        if (result2 == null) {
            result2 = this.createMapper(this.myErrorMapperFactories, source);
        }
        if (result2 == null) {
            throw new IllegalStateException("Can't create a mapper for " + source);
        }
        return result2;
    }

    public final void processMapper(@NotNull Mapper<? extends SourceT, ? extends TargetT> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        if (this.myMapperProcessors != null) {
            Intrinsics.checkNotNull(this.myMapperProcessors);
            for (MapperProcessor<? extends SourceT, ? extends TargetT> mapperProcessor : this.myMapperProcessors) {
                mapperProcessor.process(mapper);
            }
        }
    }
}

