/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.observable.collections.list;

import jetbrains.datalore.base.observable.collections.ObservableCollection;
import jetbrains.datalore.base.observable.collections.list.ObservableArrayList;
import jetbrains.datalore.base.observable.event.EventHandler;
import jetbrains.datalore.base.observable.property.PropertyChangeEvent;
import jetbrains.datalore.base.observable.property.ReadableProperty;
import jetbrains.datalore.base.registration.Registration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\b \u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\f\b\u0002\u0010\u0003*\u0006\u0012\u0002\b\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00020\u00052\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00010\u00070\u0006B+\b\u0004\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\r\u0010\u0018\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0007H\u0016J\b\u0010 \u001a\u00020\u001eH\u0014J\b\u0010!\u001a\u00020\u001eH\u0014J\r\u0010\"\u001a\u00028\u0002H\u0004\u00a2\u0006\u0002\u0010\u0019R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0084\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Ljetbrains/datalore/base/observable/collections/list/SelectedCollection;", "ValueT", "ItemT", "CollectionT", "Ljetbrains/datalore/base/observable/collections/ObservableCollection;", "Ljetbrains/datalore/base/observable/collections/list/ObservableArrayList;", "Ljetbrains/datalore/base/observable/event/EventHandler;", "Ljetbrains/datalore/base/observable/property/PropertyChangeEvent;", "mySource", "Ljetbrains/datalore/base/observable/property/ReadableProperty;", "mySelector", "Lkotlin/Function1;", "(Ljetbrains/datalore/base/observable/property/ReadableProperty;Lkotlin/jvm/functions/Function1;)V", "<set-?>", "", "isFollowing", "()Z", "mySourceListRegistration", "Ljetbrains/datalore/base/registration/Registration;", "mySourcePropertyRegistration", "size", "", "getSize", "()I", "empty", "()Ljetbrains/datalore/base/observable/collections/ObservableCollection;", "follow", "source", "(Ljetbrains/datalore/base/observable/collections/ObservableCollection;)Ljetbrains/datalore/base/registration/Registration;", "onEvent", "", "event", "onListenersAdded", "onListenersRemoved", "select", "base"})
public abstract class SelectedCollection<ValueT, ItemT, CollectionT extends ObservableCollection<?>>
extends ObservableArrayList<ItemT>
implements EventHandler<PropertyChangeEvent<? extends ValueT>> {
    @NotNull
    private final ReadableProperty<? extends ValueT> mySource;
    @NotNull
    private final Function1<ValueT, CollectionT> mySelector;
    @NotNull
    private Registration mySourcePropertyRegistration;
    @NotNull
    private Registration mySourceListRegistration;
    private boolean isFollowing;

    protected SelectedCollection(@NotNull ReadableProperty<? extends ValueT> mySource, @NotNull Function1<? super ValueT, ? extends CollectionT> mySelector) {
        Intrinsics.checkNotNullParameter(mySource, (String)"mySource");
        Intrinsics.checkNotNullParameter(mySelector, (String)"mySelector");
        this.mySource = mySource;
        this.mySelector = mySelector;
        this.mySourcePropertyRegistration = Registration.Companion.getEMPTY();
        this.mySourceListRegistration = Registration.Companion.getEMPTY();
    }

    protected final boolean isFollowing() {
        return this.isFollowing;
    }

    @Override
    public int getSize() {
        return this.isFollowing ? super.getSize() : this.select().size();
    }

    @NotNull
    protected abstract Registration follow(@NotNull CollectionT var1);

    @NotNull
    protected abstract CollectionT empty();

    @NotNull
    protected final CollectionT select() {
        Object sourceVal = this.mySource.get();
        if (sourceVal != null) {
            return (CollectionT)((ObservableCollection)this.mySelector.invoke(sourceVal));
        }
        return this.empty();
    }

    @Override
    public void onEvent(@NotNull PropertyChangeEvent<? extends ValueT> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (this.isFollowing) {
            this.mySourceListRegistration.remove();
            this.mySourceListRegistration = this.follow(this.select());
        }
    }

    @Override
    protected void onListenersAdded() {
        SelectedCollection handler2 = this;
        this.mySourcePropertyRegistration = this.mySource.addHandler(handler2);
        this.isFollowing = true;
        this.mySourceListRegistration = this.follow(this.select());
    }

    @Override
    protected void onListenersRemoved() {
        this.mySourcePropertyRegistration.remove();
        this.isFollowing = false;
        this.mySourceListRegistration.remove();
    }
}

