/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.FigureBuildInfo;
import jetbrains.datalore.plot.builder.FigureSvgRoot;
import jetbrains.datalore.plot.builder.subPlots.CompositeFigureSvgRoot;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/FigureToPlainSvg;", "", "buildInfo", "Ljetbrains/datalore/plot/builder/FigureBuildInfo;", "(Ljetbrains/datalore/plot/builder/FigureBuildInfo;)V", "eval", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "processCompositeFigure", "", "svgRoot", "Ljetbrains/datalore/plot/builder/subPlots/CompositeFigureSvgRoot;", "origin", "Ljetbrains/datalore/base/geometry/DoubleVector;", "topSvgSvg", "plot-config-portable"})
public final class FigureToPlainSvg {
    @NotNull
    private final FigureBuildInfo buildInfo;

    public FigureToPlainSvg(@NotNull FigureBuildInfo buildInfo) {
        Intrinsics.checkNotNullParameter((Object)buildInfo, (String)"buildInfo");
        this.buildInfo = buildInfo;
    }

    @NotNull
    public final SvgSvgElement eval() {
        FigureBuildInfo buildInfo = this.buildInfo.layoutedByOuterSize();
        FigureSvgRoot svgRoot = buildInfo.createSvgRoot();
        svgRoot.ensureContentBuilt();
        SvgSvgElement topSvgSvg = svgRoot.getSvg();
        if (svgRoot instanceof CompositeFigureSvgRoot) {
            this.processCompositeFigure((CompositeFigureSvgRoot)svgRoot, DoubleVector.Companion.getZERO(), topSvgSvg);
        }
        return topSvgSvg;
    }

    private final void processCompositeFigure(CompositeFigureSvgRoot svgRoot, DoubleVector origin, SvgSvgElement topSvgSvg) {
        for (FigureSvgRoot element : svgRoot.getElements()) {
            DoubleVector elementOrigin = element.getBounds().getOrigin().add(origin);
            element.ensureContentBuilt();
            SvgSvgElement elementSvg = element.getSvg();
            elementSvg.x().set((Object)elementOrigin.getX());
            elementSvg.y().set((Object)elementOrigin.getY());
            if (element instanceof CompositeFigureSvgRoot) {
                this.processCompositeFigure((CompositeFigureSvgRoot)element, elementOrigin, topSvgSvg);
            }
            topSvgSvg.children().add((Object)elementSvg);
        }
    }
}

